/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.contribution.scanner.spi.AbstractResource;
import org.fabric3.contribution.scanner.spi.FileSystemResource;

public class DirectoryResource
extends AbstractResource {
    private final File root;
    private List<FileSystemResource> resources;

    public DirectoryResource(File root) {
        this.root = root;
        this.resources = new ArrayList<FileSystemResource>();
    }

    public String getName() {
        return this.root.getName();
    }

    public long getTimestamp() {
        long latest = this.root.lastModified();
        for (FileSystemResource resource : this.resources) {
            long timestamp = resource.getTimestamp();
            if (timestamp <= latest) continue;
            latest = timestamp;
        }
        return latest;
    }

    public URL getLocation() {
        try {
            return this.root.toURI().normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void addResource(FileSystemResource resource) {
        this.resources.add(resource);
    }
}

