/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.annotation.Consumer;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.InvalidConsumerMethod;
import org.fabric3.model.type.component.ConsumerDefinition;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.fabric3.spi.model.type.java.Signature;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ConsumerProcessor
extends AbstractAnnotationProcessor<Consumer> {
    private IntrospectionHelper helper;

    public ConsumerProcessor(@Reference IntrospectionHelper helper) {
        super(Consumer.class);
        this.helper = helper;
    }

    public void visitMethod(Consumer annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        if (method.getParameterTypes().length > 1) {
            InvalidConsumerMethod failure = new InvalidConsumerMethod("Consumer method " + method + " has more than one parameter");
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        List<DataType<?>> types = this.introspectParameterTypes(method, typeMapping);
        String name = this.helper.getSiteName(method, annotation.value());
        Signature signature = new Signature(method);
        ConsumerDefinition definition = new ConsumerDefinition(name, types);
        componentType.add(definition, signature);
    }

    private List<DataType<?>> introspectParameterTypes(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalParameterTypes = method.getParameterTypes();
        Type[] gParamTypes = method.getGenericParameterTypes();
        ArrayList parameterDataTypes = new ArrayList(gParamTypes.length);
        for (int i = 0; i < gParamTypes.length; ++i) {
            Type gParamType = gParamTypes[i];
            Type logicalParamType = typeMapping.getActualType(gParamType);
            DataType<?> dataType = this.createDataType(physicalParameterTypes[i], logicalParamType, typeMapping);
            parameterDataTypes.add(dataType);
        }
        return parameterDataTypes;
    }

    private DataType<?> createDataType(Class<?> physicalType, Type type, TypeMapping mapping) {
        if (type instanceof Class) {
            return new JavaClass(physicalType);
        }
        JavaTypeInfo info = this.helper.createTypeInfo(type, mapping);
        return new JavaGenericType(info);
    }
}

