/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.InvalidAccessor;
import org.fabric3.model.type.component.CallbackDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OASISCallbackProcessor
extends AbstractAnnotationProcessor<Callback> {
    private final IntrospectionHelper helper;
    private final JavaContractProcessor contractProcessor;

    public OASISCallbackProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(Callback.class);
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    public void visitField(Callback annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        this.validate(field, context);
        String name = this.helper.getSiteName(field, null);
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        CallbackDefinition definition = this.createDefinition(name, type, implClass, context);
        componentType.add(definition, (InjectionSite)site);
    }

    public void visitMethod(Callback annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        this.validate(method, context);
        String name = this.helper.getSiteName(method, null);
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        CallbackDefinition definition = this.createDefinition(name, type, implClass, context);
        componentType.add(definition, (InjectionSite)site);
    }

    private void validate(Field field, IntrospectionContext context) {
        if (!Modifier.isProtected(field.getModifiers()) && !Modifier.isPublic(field.getModifiers())) {
            Class<?> clazz = field.getDeclaringClass();
            InvalidAccessor warning = new InvalidAccessor("Illegal callback. The field " + field.getName() + " on " + clazz.getName() + " is annotated with @Callback and must be public or protected.", clazz);
            context.addError((ValidationFailure)warning);
        }
    }

    private void validate(Method method, IntrospectionContext context) {
        if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) {
            Class<?> clazz = method.getDeclaringClass();
            InvalidAccessor warning = new InvalidAccessor("Illegal callback. The method " + method + " is annotated with @Callback and must be public or protected.", clazz);
            context.addError((ValidationFailure)warning);
        }
    }

    private CallbackDefinition createDefinition(String name, Type type, Class<?> implClass, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class baseType = this.helper.getBaseType(type, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(baseType, implClass, context);
        return new CallbackDefinition(name, (ServiceContract)contract);
    }
}

