/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.InvalidContextType;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.annotation.Context;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OASISContextProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Context> {
    private final IntrospectionHelper helper;

    public OASISContextProcessor(@Reference IntrospectionHelper helper) {
        super(Context.class);
        this.helper = helper;
    }

    public void visitField(Context annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        this.visit(type, componentType, (InjectionSite)site, field.getDeclaringClass(), context);
    }

    public void visitMethod(Context annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        this.visit(type, componentType, (InjectionSite)site, method.getDeclaringClass(), context);
    }

    private void visit(Type type, InjectingComponentType componentType, InjectionSite site, Class<?> clazz, IntrospectionContext context) {
        if (!(type instanceof Class)) {
            context.addError((ValidationFailure)new InvalidContextType("Context type " + type + " is not supported in " + clazz.getName()));
        } else if (RequestContext.class.isAssignableFrom((Class)type)) {
            componentType.addInjectionSite(site, Injectable.OASIS_REQUEST_CONTEXT);
        } else if (ComponentContext.class.isAssignableFrom((Class)type)) {
            componentType.addInjectionSite(site, Injectable.OASIS_COMPONENT_CONTEXT);
        } else {
            context.addError((ValidationFailure)new InvalidContextType("Context type is not supported: " + type));
        }
    }
}

