/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Method;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.InvalidMethod;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.Signature;
import org.oasisopen.sca.annotation.Destroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OASISDestroyProcessor
extends AbstractAnnotationProcessor<Destroy> {
    public OASISDestroyProcessor() {
        super(Destroy.class);
    }

    public void visitMethod(Destroy annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        if (!this.validate(method, context)) {
            return;
        }
        componentType.setDestroyMethod(new Signature(method));
    }

    private boolean validate(Method method, IntrospectionContext context) {
        if (!"void".equals(method.getReturnType().getName())) {
            InvalidMethod error = new InvalidMethod("Method marked with @Destroy must return void: " + method);
            context.addError((ValidationFailure)error);
            return false;
        }
        return true;
    }
}

