/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.fabric3.introspection.java.annotation.AbstractReferenceProcessor;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OASISReferenceProcessor
extends AbstractReferenceProcessor<Reference> {
    public OASISReferenceProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(Reference.class, contractProcessor, helper);
    }

    public void visitField(Reference annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(field, annotation.name());
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        Annotation[] annotations = field.getAnnotations();
        boolean required = annotation.required();
        ReferenceDefinition definition = this.createDefinition(name, required, type, implClass, annotations, context);
        componentType.add(definition, (InjectionSite)site);
    }

    public void visitMethod(Reference annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(method, annotation.name());
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        Annotation[] annotations = method.getAnnotations();
        ReferenceDefinition definition = this.createDefinition(name, annotation.required(), type, implClass, annotations, context);
        componentType.add(definition, (InjectionSite)site);
    }

    public void visitConstructorParameter(Reference annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.name());
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        Annotation[] annotations = constructor.getParameterAnnotations()[index];
        boolean required = annotation.required();
        ReferenceDefinition definition = this.createDefinition(name, required, type, implClass, annotations, context);
        componentType.add(definition, (InjectionSite)site);
    }
}

