/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.policy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOperationPolicyIntrospector
implements OperationPolicyIntrospector {
    private PolicyAnnotationProcessor policyProcessor;

    public DefaultOperationPolicyIntrospector(@Reference PolicyAnnotationProcessor policyProcessor) {
        this.policyProcessor = policyProcessor;
    }

    public void introspectPolicyOnOperations(ServiceContract contract, Class<?> implClass, IntrospectionContext context) {
        for (Operation operation : contract.getOperations()) {
            List types = operation.getInputTypes();
            Class[] params = new Class[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                Class physical;
                DataType type = (DataType)types.get(i);
                params[i] = physical = type.getPhysical();
            }
            try {
                Method method = implClass.getMethod(operation.getName(), params);
                for (Annotation annotation : method.getAnnotations()) {
                    this.policyProcessor.process(annotation, (PolicyAware)operation, context);
                }
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

