/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.JmxHelper;
import org.fabric3.runtime.weblogic.federation.JndiHelper;
import org.fabric3.runtime.weblogic.federation.RuntimeChannelImpl;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.JoinDomain;
import org.fabric3.spi.event.RuntimeStop;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.federation.DomainTopologyService;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.RuntimeInstance;
import org.fabric3.spi.federation.Zone;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=DomainTopologyService.class)
@EagerInit
public class WebLogicDomainTopologyService
implements DomainTopologyService {
    private static final String RUNTIME_NAME = "controller";
    private CommandExecutorRegistry executorRegistry;
    private EventService eventService;
    private SerializationService serializationService;
    private WebLogicTopologyMonitor monitor;
    private InitialContext rootContext;
    private EventContext participantContext;
    private RuntimeChannelImpl controllerChannel;
    private JmxHelper jmxHelper;
    private String domainName;

    public WebLogicDomainTopologyService(@Reference CommandExecutorRegistry executorRegistry, @Reference EventService eventService, @Reference SerializationService serializationService, @Reference JmxHelper jmxHelper, @Monitor WebLogicTopologyMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.eventService = eventService;
        this.serializationService = serializationService;
        this.jmxHelper = jmxHelper;
        this.monitor = monitor;
    }

    @Init
    public void init() throws NamingException, JMException {
        this.domainName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "DomainConfiguration/Name");
        this.eventService.subscribe(JoinDomain.class, (Fabric3EventListener)new JoinDomainListener());
        this.eventService.subscribe(RuntimeStop.class, (Fabric3EventListener)new RuntimeStopListener());
    }

    public Set<Zone> getZones() {
        List<RuntimeInstance> runtimes = this.getRuntimes();
        if (runtimes.isEmpty()) {
            return Collections.emptySet();
        }
        Zone zone = new Zone(this.domainName, runtimes);
        return Collections.singleton(zone);
    }

    public List<RuntimeInstance> getRuntimes() {
        ArrayList<RuntimeInstance> instances = new ArrayList<RuntimeInstance>();
        try {
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                String runtimeName = channel.getRuntimeName();
                Map map = Collections.emptyMap();
                RuntimeInstance runtimeInstance = new RuntimeInstance(runtimeName, map);
                instances.add(runtimeInstance);
            }
        }
        catch (NamingException e) {
            this.monitor.error(e);
        }
        catch (RemoteException e) {
            this.monitor.error(e);
        }
        return instances;
    }

    public String getTransportMetaData(String zone, String transport) {
        return "";
    }

    public void broadcast(Command command) throws MessageException {
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                if (!channel.isActive()) continue;
                channel.send(payload);
            }
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
    }

    public void broadcast(String zoneName, Command command) throws MessageException {
        List<RuntimeChannel> channels = this.getChannels();
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            for (RuntimeChannel channel : channels) {
                if (!channel.isActive()) continue;
                channel.send(payload);
            }
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
    }

    public List<Response> sendSynchronousToZone(String zoneName, ResponseCommand command, boolean failFast, long timeout) throws MessageException {
        byte[] payload;
        List<RuntimeChannel> channels = this.getChannels();
        if (channels.isEmpty()) {
            throw new MessageException("No managed servers found to deploy to");
        }
        ArrayList<Response> responses = new ArrayList<Response>();
        try {
            payload = this.serializationService.serialize((Serializable)command);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        for (RuntimeChannel channel : channels) {
            try {
                if (!channel.isActive()) continue;
                byte[] responsePayload = channel.sendSynchronous(payload);
                Response response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
                responses.add(response);
            }
            catch (ChannelException e) {
                throw new MessageException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new MessageException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MessageException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessageException((Throwable)e);
            }
        }
        return responses;
    }

    public Response sendSynchronous(String runtimeName, ResponseCommand command, long timeout) throws MessageException {
        try {
            RuntimeChannel runtimeChannel = null;
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                if (!runtimeName.equals(channel.getRuntimeName())) continue;
                runtimeChannel = channel;
                break;
            }
            if (runtimeChannel == null) {
                throw new MessageException("Runtime not found: " + runtimeName);
            }
            if (!runtimeChannel.isActive()) {
                throw new MessageException("Runtime is not active: " + runtimeName);
            }
            byte[] payload = this.serializationService.serialize((Serializable)command);
            byte[] responsePayload = runtimeChannel.sendSynchronous(payload);
            return (Response)this.serializationService.deserialize(Response.class, responsePayload);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MessageException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MessageException((Throwable)e);
        }
    }

    private List<RuntimeChannel> getChannels() throws MessageException {
        try {
            ArrayList<RuntimeChannel> channels = new ArrayList<RuntimeChannel>();
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                channels.add(channel);
            }
            return channels;
        }
        catch (NameNotFoundException e) {
            this.monitor.noManagedServers();
            return Collections.emptyList();
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
    }

    private void bindController() {
        try {
            this.controllerChannel = new RuntimeChannelImpl(RUNTIME_NAME, this.executorRegistry, this.serializationService, this.monitor);
            this.rootContext = new InitialContext();
            Context controllerContext = JndiHelper.getContext("Fabric3ControllerContext", this.rootContext);
            try {
                controllerContext.bind("Fabric3ControllerChannel", (Object)this.controllerChannel);
            }
            catch (NameAlreadyBoundException e) {
                controllerContext.rebind("Fabric3ControllerChannel", (Object)this.controllerChannel);
            }
            Context ctx = JndiHelper.getContext("Fabric3Participants", this.rootContext);
            assert (ctx instanceof EventContext);
            this.participantContext = (EventContext)ctx;
        }
        catch (NamingException e) {
            this.monitor.errorMessage("Error initializing domain topology service", e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuntimeStopListener
    implements Fabric3EventListener<RuntimeStop> {
        private RuntimeStopListener() {
        }

        public void onEvent(RuntimeStop event) {
            if (WebLogicDomainTopologyService.this.controllerChannel != null) {
                WebLogicDomainTopologyService.this.controllerChannel.shutdown();
            }
            if (WebLogicDomainTopologyService.this.rootContext != null) {
                try {
                    WebLogicDomainTopologyService.this.rootContext.unbind("Fabric3ControllerChannel");
                    WebLogicDomainTopologyService.this.rootContext.close();
                }
                catch (NamingException e) {
                    WebLogicDomainTopologyService.this.monitor.error(e);
                }
            }
            if (WebLogicDomainTopologyService.this.participantContext != null) {
                try {
                    WebLogicDomainTopologyService.this.participantContext.close();
                }
                catch (NamingException e) {
                    WebLogicDomainTopologyService.this.monitor.error(e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinDomainListener
    implements Fabric3EventListener<JoinDomain> {
        private JoinDomainListener() {
        }

        public void onEvent(JoinDomain event) {
            WebLogicDomainTopologyService.this.bindController();
        }
    }
}

