/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.management.JMException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateResponse;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.JmxHelper;
import org.fabric3.runtime.weblogic.federation.JndiHelper;
import org.fabric3.runtime.weblogic.federation.RuntimeChannelImpl;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.JoinDomain;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.MessageReceiver;
import org.fabric3.spi.federation.TopologyListener;
import org.fabric3.spi.federation.ZoneChannelException;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=ZoneTopologyService.class)
@EagerInit
public class WebLogicZoneTopologyService
implements ZoneTopologyService {
    private static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private ExecutorService executorService;
    private WebLogicTopologyMonitor monitor;
    private EventService eventService;
    private SerializationService serializationService;
    private CommandExecutorRegistry executorRegistry;
    private JmxHelper jmxHelper;
    private RuntimeChannel runtimeChannel;
    private RuntimeChannel controllerChannel;
    private String runtimeName;
    private String adminServerUrl = "t3://localhost:7001";
    private boolean synchronize = true;
    private String zoneName;
    private List<ChannelOpenRequest> channelRequests = new ArrayList<ChannelOpenRequest>();

    public WebLogicZoneTopologyService(@Reference EventService eventService, @Reference SerializationService serializationService, @Reference CommandExecutorRegistry executorRegistry, @Reference ExecutorService executorService, @Reference JmxHelper jmxHelper, @Monitor WebLogicTopologyMonitor monitor) {
        this.eventService = eventService;
        this.serializationService = serializationService;
        this.executorRegistry = executorRegistry;
        this.jmxHelper = jmxHelper;
        this.executorService = executorService;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setAdminServerUrl(String adminServerUrl) {
        this.adminServerUrl = adminServerUrl;
    }

    @Property(required=false)
    public void setSynchronize(boolean synchronize) {
        this.synchronize = synchronize;
    }

    @Init
    public void init() throws JMException {
        this.runtimeName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "ServerRuntime/Name");
        this.zoneName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "DomainConfiguration/Name");
        this.eventService.subscribe(JoinDomain.class, (Fabric3EventListener)new JoinDomainListener());
        this.runtimeChannel = new RuntimeChannelImpl(this.runtimeName, this.executorRegistry, this.serializationService, this.monitor);
    }

    public boolean isZoneLeader() {
        return false;
    }

    public boolean supportsDynamicChannels() {
        return true;
    }

    public void register(TopologyListener listener) {
    }

    public void deregister(TopologyListener listener) {
    }

    public void registerMetadata(String key, Serializable metadata) {
    }

    public boolean isControllerAvailable() {
        return true;
    }

    public String getZoneLeaderName() {
        return null;
    }

    public Response sendSynchronousToController(ResponseCommand command, long timeout) throws MessageException {
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            byte[] responsePayload = this.controllerChannel.sendSynchronous(payload);
            return (Response)this.serializationService.deserialize(Response.class, responsePayload);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MessageException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MessageException((Throwable)e);
        }
    }

    public void broadcast(Command command) throws MessageException {
        throw new UnsupportedOperationException();
    }

    public void sendAsynchronous(String runtimeName, Command command) throws MessageException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response sendSynchronous(String destinationName, ResponseCommand command, long timeout) throws MessageException {
        Response response;
        Context rootContext;
        block10: {
            rootContext = null;
            try {
                rootContext = this.getRootContext();
                byte[] payload = this.serializationService.serialize((Serializable)command);
                NamingEnumeration<Binding> enumeration = rootContext.listBindings("Fabric3Participants");
                while (enumeration.hasMoreElements()) {
                    RuntimeChannel channel;
                    Binding binding = enumeration.next();
                    if (!RuntimeChannel.class.getName().equals(binding.getClassName()) || !destinationName.equals((channel = (RuntimeChannel)binding.getObject()).getRuntimeName()) || !channel.isActive()) continue;
                    byte[] responsePayload = this.runtimeChannel.sendSynchronous(payload);
                    response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
                    break block10;
                }
                throw new MessageException("Runtime not found: " + destinationName);
            }
            catch (NamingException e) {
                throw new MessageException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new MessageException((Throwable)e);
            }
            catch (ChannelException e) {
                throw new MessageException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessageException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MessageException((Throwable)e);
            }
            catch (Throwable throwable) {
                JndiHelper.close(rootContext);
                throw throwable;
            }
        }
        JndiHelper.close(rootContext);
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Response> sendSynchronous(ResponseCommand command, long timeout) throws MessageException {
        ArrayList<Response> arrayList;
        ArrayList<Response> responses = new ArrayList<Response>();
        Context rootContext = null;
        try {
            rootContext = this.getRootContext();
            byte[] payload = this.serializationService.serialize((Serializable)command);
            NamingEnumeration<Binding> enumeration = rootContext.listBindings("Fabric3Participants");
            if (!enumeration.hasMoreElements()) {
                throw new MessageException("No runtimes in domain");
            }
            while (enumeration.hasMoreElements()) {
                RuntimeChannel channel;
                Binding binding = enumeration.next();
                if (!RuntimeChannel.class.getName().equals(binding.getClassName()) || this.runtimeName.equals((channel = (RuntimeChannel)binding.getObject()).getRuntimeName()) || !channel.isActive()) continue;
                byte[] responsePayload = channel.sendSynchronous(payload);
                Response response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
                responses.add(response);
            }
            arrayList = responses;
        }
        catch (NamingException e) {
            try {
                throw new MessageException((Throwable)e);
                catch (RemoteException e2) {
                    throw new MessageException((Throwable)e2);
                }
                catch (ChannelException e3) {
                    throw new MessageException((Throwable)e3);
                }
                catch (IOException e4) {
                    throw new MessageException((Throwable)e4);
                }
                catch (ClassNotFoundException e5) {
                    throw new MessageException((Throwable)e5);
                }
            }
            catch (Throwable throwable) {
                JndiHelper.close(rootContext);
                throw throwable;
            }
        }
        JndiHelper.close(rootContext);
        return arrayList;
    }

    public void sendAsynchronousToController(Command command) throws MessageException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void openChannel(String name, String configuration, MessageReceiver receiver) throws ZoneChannelException {
        Context rootContext = null;
        Context dynamicChannelContext = null;
        RuntimeChannelImpl channel = new RuntimeChannelImpl(this.runtimeName, this.executorRegistry, this.serializationService, receiver, this.monitor);
        try {
            rootContext = this.getRootContext();
            dynamicChannelContext = JndiHelper.getContext("Fabric3DynamicChannels", rootContext);
            dynamicChannelContext.bind(name + ":" + this.runtimeName, (Object)channel);
        }
        catch (NameAlreadyBoundException e) {
            try {
                dynamicChannelContext.rebind(name + ":" + this.runtimeName, (Object)channel);
            }
            catch (NamingException ex) {
                this.monitor.errorMessage("Controller not available - queueing request for retry");
                this.monitor.errorDetail(ex);
                this.channelRequests.add(new ChannelOpenRequest(name, receiver));
            }
            JndiHelper.close(rootContext, dynamicChannelContext);
        }
        catch (NamingException e2) {
            this.monitor.errorMessage("Controller not available - queueing request for retry");
            this.monitor.errorDetail(e2);
            this.channelRequests.add(new ChannelOpenRequest(name, receiver));
            {
                catch (Throwable throwable) {
                    JndiHelper.close(rootContext, dynamicChannelContext);
                    throw throwable;
                }
            }
            JndiHelper.close(rootContext, dynamicChannelContext);
        }
        JndiHelper.close(rootContext, dynamicChannelContext);
    }

    /*
     * Loose catch block
     */
    public void closeChannel(String name) throws ZoneChannelException {
        Context rootContext = null;
        Context dynamicChannelContext = null;
        try {
            rootContext = this.getRootContext();
            dynamicChannelContext = JndiHelper.getContext("Fabric3DynamicChannels", rootContext);
            dynamicChannelContext.unbind(name + ":" + this.runtimeName);
        }
        catch (CommunicationException e) {
            JndiHelper.close(rootContext, dynamicChannelContext);
        }
        catch (NamingException e2) {
            throw new ZoneChannelException((Throwable)e2);
            {
                catch (Throwable throwable) {
                    JndiHelper.close(rootContext, dynamicChannelContext);
                    throw throwable;
                }
            }
        }
        JndiHelper.close(rootContext, dynamicChannelContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAsynchronous(String name, Serializable message) throws MessageException {
        Context rootContext = null;
        try {
            rootContext = this.getRootContext();
            byte[] payload = this.serializationService.serialize(message);
            NamingEnumeration<Binding> enumeration = rootContext.listBindings("Fabric3DynamicChannels");
            while (enumeration.hasMoreElements()) {
                Binding binding = enumeration.next();
                if (!RuntimeChannel.class.getName().equals(binding.getClassName())) continue;
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                if (!binding.getName().startsWith(name + ":") || channel.getRuntimeName().equals(this.runtimeName)) continue;
                channel.publish(payload);
            }
        }
        catch (NamingException e) {
            try {
                throw new MessageException((Throwable)e);
                catch (RemoteException e2) {
                    throw new MessageException((Throwable)e2);
                }
                catch (ChannelException e3) {
                    throw new MessageException((Throwable)e3);
                }
                catch (IOException e4) {
                    throw new MessageException((Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                JndiHelper.close(rootContext);
                throw throwable;
            }
        }
        JndiHelper.close(rootContext);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAsynchronous(String destinationName, String name, Serializable message) throws MessageException {
        Context rootContext;
        block9: {
            rootContext = null;
            try {
                rootContext = this.getRootContext();
                byte[] payload = this.serializationService.serialize(message);
                NamingEnumeration<Binding> enumeration = rootContext.listBindings("Fabric3DynamicChannels");
                while (enumeration.hasMoreElements()) {
                    Binding binding = enumeration.next();
                    if (!RuntimeChannel.class.getName().equals(binding.getClassName())) continue;
                    RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                    if (!binding.getName().equals(name + ":" + destinationName)) continue;
                    channel.publish(payload);
                    break block9;
                }
                throw new MessageException("Runtime not found: " + destinationName);
            }
            catch (NamingException e) {
                throw new MessageException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new MessageException((Throwable)e);
            }
            catch (ChannelException e) {
                throw new MessageException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessageException((Throwable)e);
            }
            catch (Throwable throwable) {
                JndiHelper.close(rootContext);
                throw throwable;
            }
        }
        JndiHelper.close(rootContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initJndiContexts() {
        boolean i$;
        Context dynamicChannelContext;
        Context controllerContext;
        Context participantContext;
        Context rootContext;
        block10: {
            this.monitor.connectingToAdminServer();
            rootContext = null;
            participantContext = null;
            controllerContext = null;
            dynamicChannelContext = null;
            rootContext = this.getRootContext();
            controllerContext = JndiHelper.getContext("Fabric3ControllerContext", rootContext);
            this.controllerChannel = (RuntimeChannel)controllerContext.lookup("Fabric3ControllerChannel");
            if (this.controllerChannel.isActive()) break block10;
            this.controllerChannel = null;
            this.monitor.errorMessage("Error joining the domain, as the controller is not active. Scheduled for retry.");
            boolean bl = false;
            JndiHelper.close(participantContext, controllerContext, rootContext, dynamicChannelContext);
            return bl;
        }
        try {
            participantContext = JndiHelper.getContext("Fabric3Participants", rootContext);
            try {
                participantContext.bind(this.runtimeName, (Object)this.runtimeChannel);
            }
            catch (NameAlreadyBoundException e) {
                participantContext.rebind(this.runtimeName, (Object)this.runtimeChannel);
            }
            dynamicChannelContext = JndiHelper.getContext("Fabric3DynamicChannels", rootContext);
            for (ChannelOpenRequest request : this.channelRequests) {
                MessageReceiver receiver = request.getReceiver();
                RuntimeChannelImpl channel = new RuntimeChannelImpl(this.runtimeName, this.executorRegistry, this.serializationService, receiver, this.monitor);
                try {
                    dynamicChannelContext.bind(request.getName() + ":" + this.runtimeName, (Object)channel);
                }
                catch (NameAlreadyBoundException e) {
                    dynamicChannelContext.rebind(request.getName() + ":" + this.runtimeName, (Object)channel);
                }
            }
            i$ = true;
        }
        catch (NamingException e) {
            boolean bl;
            try {
                this.monitor.errorMessage("Error joining the domain, possibly because the controller is not available. Scheduled for retry.");
                this.monitor.errorDetail(e);
                bl = false;
            }
            catch (Throwable throwable) {
                JndiHelper.close(participantContext, controllerContext, rootContext, dynamicChannelContext);
                throw throwable;
            }
            JndiHelper.close(participantContext, controllerContext, rootContext, dynamicChannelContext);
            return bl;
        }
        JndiHelper.close(participantContext, controllerContext, rootContext, dynamicChannelContext);
        return i$;
    }

    private Context getRootContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", JNDI_FACTORY);
        env.put("java.naming.provider.url", this.adminServerUrl);
        InitialContext rootContext = new InitialContext(env);
        return rootContext;
    }

    private boolean update() {
        Response response;
        if (!this.synchronize) {
            return true;
        }
        this.monitor.updating();
        RuntimeUpdateCommand command = new RuntimeUpdateCommand(this.runtimeName, this.zoneName, null);
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            if (this.controllerChannel == null || !this.controllerChannel.isActive()) {
                return false;
            }
            byte[] responsePayload = this.controllerChannel.sendSynchronous(payload);
            response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
        }
        catch (RemoteException e) {
            this.monitor.error(e);
            return false;
        }
        catch (ChannelException e) {
            this.monitor.error(e);
            return false;
        }
        catch (IOException e) {
            this.monitor.error(e);
            return false;
        }
        catch (ClassNotFoundException e) {
            this.monitor.error(e);
            return false;
        }
        RuntimeUpdateResponse updateResponse = (RuntimeUpdateResponse)response;
        if (!updateResponse.isUpdated()) {
            return false;
        }
        try {
            DeploymentCommand deploymentCommand = updateResponse.getDeploymentCommand();
            this.executorRegistry.execute((Command)deploymentCommand);
        }
        catch (ExecutionException e) {
            this.monitor.error(e);
            return true;
        }
        this.monitor.updated();
        return true;
    }

    private class ChannelOpenRequest {
        private String name;
        private MessageReceiver receiver;

        private ChannelOpenRequest(String name, MessageReceiver receiver) {
            this.name = name;
            this.receiver = receiver;
        }

        public String getName() {
            return this.name;
        }

        public MessageReceiver getReceiver() {
            return this.receiver;
        }
    }

    private class Work
    implements Runnable {
        private Work() {
        }

        public void run() {
            while (!WebLogicZoneTopologyService.this.initJndiContexts() || !WebLogicZoneTopologyService.this.update()) {
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinDomainListener
    implements Fabric3EventListener<JoinDomain> {
        private JoinDomainListener() {
        }

        public void onEvent(JoinDomain event) {
            if (!WebLogicZoneTopologyService.this.initJndiContexts()) {
                WebLogicZoneTopologyService.this.monitor.adminServerUnavailable();
                WebLogicZoneTopologyService.this.executorService.execute(new Work());
                return;
            }
            WebLogicZoneTopologyService.this.update();
        }
    }
}

