/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Link;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.management.rest.spi.ResourceListener;
import org.fabric3.management.rest.spi.ResourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Management
public abstract class AbstractResourceService
implements ResourceListener {
    private List<ResourceMapping> subresources = new ArrayList<ResourceMapping>();

    @Override
    public void onRootResourceExport(ResourceMapping mapping) {
        if (mapping.getInstance() == this) {
            return;
        }
        String path = this.getResourcePath() + "/";
        if (!mapping.getPath().startsWith(path)) {
            return;
        }
        if (!mapping.isParameterized() && mapping.getPath().substring(path.length()).contains("/")) {
            return;
        }
        mapping = this.convertMapping(mapping);
        this.subresources.remove(mapping);
        this.subresources.add(mapping);
    }

    @Override
    public void onSubResourceExport(ResourceMapping mapping) {
    }

    @Override
    public void onRootResourceRemove(String identifier) {
    }

    @Override
    public void onSubResourceRemove(String identifier) {
    }

    @ManagementOperation(path="/")
    public Resource getResource(HttpServletRequest request) {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        this.populateResource(resource, request);
        String requestUrl = ResourceHelper.getRequestUrl(request);
        for (ResourceMapping mapping : this.subresources) {
            String path = "/".equals(mapping.getRelativePath()) ? mapping.getPath().substring(this.getResourcePath().length() + 1) : mapping.getRelativePath().substring(this.getResourcePath().length() + 1);
            URL url = ResourceHelper.createUrl(requestUrl + '/' + path);
            Link link = new Link(path, "edit", url);
            resource.setProperty(link.getName(), link);
        }
        return resource;
    }

    protected abstract String getResourcePath();

    protected void populateResource(Resource resource, HttpServletRequest request) {
    }

    protected ResourceMapping convertMapping(ResourceMapping mapping) {
        return mapping;
    }

    protected List<ResourceMapping> getSubresources() {
        return this.subresources;
    }
}

