/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain;

import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Link;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.SelfLink;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain")
public class DistributedDomainResourceService {
    private HostInfo info;

    public DistributedDomainResourceService(@Reference HostInfo info) {
        this.info = info;
    }

    @ManagementOperation(path="/")
    public Resource getDomainResource(HttpServletRequest request) {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        this.createZoneLinks(request, resource);
        this.createRuntimeLinks(request, resource);
        this.createContributionsLink(request, resource);
        this.createDeploymentsLink(request, resource);
        this.createComponentsLink(request, resource);
        return resource;
    }

    private void createZoneLinks(HttpServletRequest request, Resource resource) {
        if (this.info.getRuntimeMode() == RuntimeMode.VM) {
            return;
        }
        URL url = ResourceHelper.createUrl(request.getRequestURL().toString() + "/zones");
        Link link = new Link("zones", "edit", url);
        resource.setProperty("zones", link);
    }

    private void createRuntimeLinks(HttpServletRequest request, Resource resource) {
        if (this.info.getRuntimeMode() == RuntimeMode.VM) {
            return;
        }
        URL url = ResourceHelper.createUrl(request.getRequestURL().toString() + "/runtimes");
        Link link = new Link("runtimes", "edit", url);
        resource.setProperty("runtimes", link);
    }

    private void createContributionsLink(HttpServletRequest request, Resource resource) {
        URL url = ResourceHelper.createUrl(ResourceHelper.getRequestUrl(request) + "/contributions");
        Link link = new Link("contributions", "edit", url);
        resource.setProperty("contributions", link);
    }

    private void createDeploymentsLink(HttpServletRequest request, Resource resource) {
        URL url = ResourceHelper.createUrl(ResourceHelper.getRequestUrl(request) + "/deployments");
        Link link = new Link("deployments", "edit", url);
        resource.setProperty("deployments", link);
    }

    private void createComponentsLink(HttpServletRequest request, Resource resource) {
        URL url = ResourceHelper.createUrl(ResourceHelper.getRequestUrl(request) + "/components");
        Link link = new Link("components", "edit", url);
        resource.setProperty("components", link);
    }
}

