/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.contribution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.stream.InputStreamSource;
import org.fabric3.host.stream.Source;

public class WrappedStreamContributionSource
implements ContributionSource {
    private URI uri;
    private InputStreamSource source;
    private boolean extension;

    public WrappedStreamContributionSource(URI uri, InputStream stream, boolean extension) {
        this.uri = uri;
        this.extension = extension;
        StreamWrapper wrapper = new StreamWrapper(stream);
        this.source = new InputStreamSource(uri.toString(), (InputStream)wrapper);
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean persist() {
        return true;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public Source getSource() {
        return this.source;
    }

    public URL getLocation() {
        return null;
    }

    public long getTimestamp() {
        return 0L;
    }

    public String getContentType() {
        return null;
    }

    private class StreamWrapper
    extends InputStream {
        private InputStream wrapped;

        private StreamWrapper(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        public int read() throws IOException {
            return this.wrapped.read();
        }

        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.wrapped.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        public int available() throws IOException {
            return this.wrapped.available();
        }

        public void close() throws IOException {
        }

        public void mark(int readLimit) {
            this.wrapped.mark(readLimit);
        }

        public void reset() throws IOException {
            this.wrapped.reset();
        }

        public boolean markSupported() {
            return this.wrapped.markSupported();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

