/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.runtime;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Link;
import org.fabric3.spi.federation.DomainTopologyService;
import org.fabric3.spi.federation.RuntimeInstance;
import org.fabric3.spi.federation.Zone;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Management(path="/domain/runtimes")
public class RuntimesResourceService {
    private HostInfo info;
    private DomainTopologyService topologyService;

    public RuntimesResourceService(@Reference HostInfo info) {
        this.info = info;
    }

    @Reference(required=false)
    public void setTopologyService(DomainTopologyService topologyService) {
        this.topologyService = topologyService;
    }

    @ManagementOperation(path="/")
    public Set<Link> getRuntimes(HttpServletRequest request) {
        if (this.topologyService == null) {
            return this.createLocalRuntimeLink(request);
        }
        return this.createDistributedRuntimesLink();
    }

    private Set<Link> createLocalRuntimeLink(HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        URL runtimeUrl = ResourceHelper.createUrl(requestUrl.substring(0, requestUrl.toString().indexOf("/management/") + 12) + "runtime");
        Link link = new Link(this.info.getRuntimeName(), "edit", runtimeUrl);
        return Collections.singleton(link);
    }

    private Set<Link> createDistributedRuntimesLink() {
        HashSet<Link> list = new HashSet<Link>();
        Set zones = this.topologyService.getZones();
        for (Zone zone : zones) {
            for (RuntimeInstance runtime : zone.getRuntimes()) {
                String httpPort = ((Integer)runtime.getMetadata(Integer.class, "http.port")).toString();
                String host = (String)((Object)runtime.getMetadata(String.class, "http.host"));
                URL runtimeUrl = ResourceHelper.createUrl("http://" + host + ":" + httpPort + "/management/runtime");
                Link link = new Link(runtime.getName(), "edit", runtimeUrl);
                list.add(link);
            }
        }
        return list;
    }
}

