/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.zone;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Link;
import org.fabric3.spi.federation.DomainTopologyService;
import org.fabric3.spi.federation.RuntimeInstance;
import org.fabric3.spi.federation.Zone;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Management(path="/domain/zones")
public class ZonesResourceService {
    private DomainTopologyService topologyService;

    @Reference(required=false)
    public void setTopologyService(DomainTopologyService topologyService) {
        this.topologyService = topologyService;
    }

    @ManagementOperation(path="/")
    public Set<Link> getZones(HttpServletRequest request) {
        if (this.topologyService == null) {
            return this.createLocalZoneLink(request);
        }
        return this.createDistributedZonesLink();
    }

    private Set<Link> createLocalZoneLink(HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        URL zoneUrl = ResourceHelper.createUrl(requestUrl.substring(0, requestUrl.toString().indexOf("/management/") + 12) + "zone");
        Link link = new Link("LocalZone", "edit", zoneUrl);
        return Collections.singleton(link);
    }

    private Set<Link> createDistributedZonesLink() {
        HashSet<Link> list = new HashSet<Link>();
        Set zones = this.topologyService.getZones();
        for (Zone zone : zones) {
            RuntimeInstance leader = (RuntimeInstance)zone.getRuntimes().get(0);
            String httpPort = ((Integer)leader.getMetadata(Integer.class, "http.port")).toString();
            String host = (String)((Object)leader.getMetadata(String.class, "http.host"));
            URL zoneUrl = ResourceHelper.createUrl("http://" + host + ":" + httpPort + "/management/zone");
            Link link = new Link(zone.getName(), "edit", zoneUrl);
            list.add(link);
        }
        return list;
    }
}

