/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.runtime;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fabric3.management.rest.runtime.TransformerPair;
import org.fabric3.management.rest.runtime.TransformerPairService;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerPairServiceImpl
implements TransformerPairService {
    private static final JavaClass<?> JAVA_TYPE = new JavaClass(Object.class);
    private TransformerRegistry registry;

    public TransformerPairServiceImpl(@Reference TransformerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public TransformerPair getTransformerPair(List<Method> methods, DataType<?> inputType, DataType<?> outputType) throws TransformationException {
        Object type;
        ArrayList list = new ArrayList();
        if (methods.size() == 1) {
            Method method = methods.get(0);
            type = Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 1 ? new JavaClass(method.getParameterTypes()[0]) : JAVA_TYPE;
        } else {
            for (Method method : methods) {
                list.addAll(Arrays.asList(method.getParameterTypes()));
                list.addAll(Arrays.asList(method.getExceptionTypes()));
                list.add(method.getReturnType());
            }
            type = JAVA_TYPE;
        }
        Transformer deserializer = this.registry.getTransformer(inputType, type, list, list);
        Transformer serializer = this.registry.getTransformer((DataType)type, outputType, list, list);
        return new TransformerPair((Transformer<InputStream, Object>)deserializer, (Transformer<Object, byte[]>)serializer);
    }
}

