/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.spi;

import java.lang.reflect.Method;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.Role;
import org.fabric3.management.rest.runtime.TransformerPair;
import org.fabric3.management.rest.spi.Verb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapping {
    private String identifier;
    private String path;
    private String relativePath;
    private Verb verb;
    private Method method;
    private Object instance;
    private boolean replicate;
    private TransformerPair pair;
    private Set<Role> roles;

    public ResourceMapping(String identifier, String path, String relativePath, Verb verb, Method method, Object instance, TransformerPair pair, Set<Role> roles) {
        this(identifier, path, relativePath, verb, method, instance, false, pair, roles);
    }

    public ResourceMapping(String identifier, String path, String relativePath, Verb verb, Method method, Object instance, boolean replicate, TransformerPair pair, Set<Role> roles) {
        this.identifier = identifier;
        this.path = path;
        this.relativePath = relativePath;
        this.verb = verb;
        this.method = method;
        this.instance = instance;
        this.replicate = replicate;
        this.pair = pair;
        this.roles = roles;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean isParameterized() {
        if ((Verb.PUT == this.verb || Verb.POST == this.verb) && this.method.getParameterTypes().length > 0 && HttpServletRequest.class.isAssignableFrom(this.method.getParameterTypes()[0])) {
            return true;
        }
        return this.method.getParameterTypes().length > 0 && !HttpServletRequest.class.isAssignableFrom(this.method.getParameterTypes()[0]);
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public boolean isReplicate() {
        return this.replicate;
    }

    public TransformerPair getPair() {
        return this.pair;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }
}

