/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SystemImplementationLoader
extends AbstractValidatingTypeLoader<SystemImplementation> {
    private ImplementationProcessor implementationProcessor;

    public SystemImplementationLoader(@Reference ImplementationProcessor implementationProcessor) {
        this.implementationProcessor = implementationProcessor;
        this.addAttributes(new String[]{"class"});
    }

    public SystemImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        this.validateAttributes(reader, introspectionContext);
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("Implementation class must be specified using the class attribute", reader);
            introspectionContext.addError((ValidationFailure)failure);
            return null;
        }
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        SystemImplementation implementation = new SystemImplementation();
        implementation.setImplementationClass(implClass);
        InjectingComponentType componentType = this.implementationProcessor.introspect(implClass, introspectionContext);
        implementation.setComponentType((ComponentType)componentType);
        return implementation;
    }
}

