/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationRuntimeException;

public class SystemInvokerInterceptor
implements Interceptor {
    private final Method operation;
    private final AtomicComponent component;

    public SystemInvokerInterceptor(Method operation, AtomicComponent component) {
        this.operation = operation;
        this.component = component;
    }

    public void setNext(Interceptor next) {
        throw new UnsupportedOperationException();
    }

    public Interceptor getNext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        Object instance;
        Object body = msg.getBody();
        WorkContext workContext = msg.getWorkContext();
        try {
            instance = this.component.getInstance(workContext);
        }
        catch (InstanceLifecycleException e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
        try {
            WorkContext oldWorkContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
            try {
                msg.setBody(this.operation.invoke(instance, (Object[])body));
            }
            catch (InvocationTargetException e) {
                msg.setBodyWithFault((Object)e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
            finally {
                WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
            }
            Message message = msg;
            return message;
        }
        finally {
            try {
                this.component.releaseInstance(instance, workContext);
            }
            catch (InstanceDestructionException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
        }
    }
}

