/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import org.fabric3.implementation.pojo.builder.PojoSourceWireAttacher;
import org.fabric3.implementation.pojo.builder.ProxyCreationException;
import org.fabric3.implementation.pojo.builder.WireProxyService;
import org.fabric3.implementation.system.provision.SystemSourceDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SystemSourceWireAttacher
extends PojoSourceWireAttacher
implements SourceWireAttacher<SystemSourceDefinition> {
    private final ComponentManager manager;
    private WireProxyService proxyService;

    public SystemSourceWireAttacher(@Reference ComponentManager manager, @Reference TransformerRegistry transformerRegistry, @Reference ClassLoaderRegistry classLoaderRegistry) {
        super(transformerRegistry, classLoaderRegistry);
        this.manager = manager;
    }

    @Reference(required=false)
    public void setProxyService(WireProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public void attach(SystemSourceDefinition source, PhysicalTargetDefinition target, Wire wire) throws WiringException {
        Class type;
        if (this.proxyService == null) {
            throw new WiringException("Attempt to inject a non-optimized wire during runtime bootstrap.");
        }
        URI sourceUri = source.getUri();
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(source.getClassLoaderId(), source.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = source.getInterfaceName();
            throw new WireAttachException("Unable to load interface class: " + name, sourceUri, null, (Throwable)e);
        }
        if (InjectableType.CALLBACK.equals((Object)injectable.getType())) {
            throw new UnsupportedOperationException("Callbacks are not supported on system components");
        }
        String callbackUri = null;
        URI uri = target.getCallbackUri();
        if (uri != null) {
            callbackUri = uri.toString();
        }
        try {
            ObjectFactory factory = this.proxyService.createObjectFactory(type, wire, callbackUri);
            if (source.isKeyed()) {
                Object key = this.getKey(source, target);
                component.setObjectFactory(injectable, factory, key);
            } else {
                component.setObjectFactory(injectable, factory);
            }
        }
        catch (ProxyCreationException e) {
            throw new WiringException((Throwable)e);
        }
    }

    public void detach(SystemSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        this.detachObjectFactory(source, target);
    }

    public void detachObjectFactory(SystemSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }

    public void attachObjectFactory(SystemSourceDefinition source, ObjectFactory<?> factory, PhysicalTargetDefinition target) throws WiringException {
        URI sourceId = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceId);
        Injectable injectable = source.getInjectable();
        if (source.isKeyed()) {
            Object key = this.getKey(source, target);
            component.setObjectFactory(injectable, factory, key);
        } else {
            component.setObjectFactory(injectable, factory);
        }
    }
}

