/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import org.fabric3.implementation.pojo.component.InvokerEventStreamHandler;
import org.fabric3.implementation.system.provision.SystemConnectionTargetDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.type.java.Signature;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SystemTargetConnectionAttacher
implements TargetConnectionAttacher<SystemConnectionTargetDefinition> {
    private ComponentManager manager;
    private ClassLoaderRegistry classLoaderRegistry;

    public SystemTargetConnectionAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalConnectionSourceDefinition source, SystemConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        URI targetUri = target.getTargetUri();
        URI targetName = UriHelper.getDefragmentedName((URI)targetUri);
        SystemComponent component = (SystemComponent)this.manager.getComponent(targetName);
        if (component == null) {
            throw new ConnectionAttachException("Target component not found: " + targetName);
        }
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
        Method method = this.loadMethod(target, component);
        InvokerEventStreamHandler handler = new InvokerEventStreamHandler(method, (AtomicComponent)component, loader);
        for (EventStream stream : connection.getEventStreams()) {
            stream.addHandler((EventStreamHandler)handler);
        }
    }

    public void detach(PhysicalConnectionSourceDefinition source, SystemConnectionTargetDefinition target) throws ConnectionAttachException {
    }

    private Method loadMethod(SystemConnectionTargetDefinition target, SystemComponent component) throws ConnectionAttachException {
        Signature signature = target.getConsumerSignature();
        Class implementationClass = component.getImplementationClass();
        try {
            return signature.getMethod(implementationClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
    }
}

