/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jndi.runtime;

import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.fabric3.jndi.provision.PhysicalJndiContextDefinition;
import org.fabric3.jndi.spi.JndiContextManager;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.resource.ResourceBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JndiContextBuilder
implements ResourceBuilder<PhysicalJndiContextDefinition> {
    private JndiContextManager manager;

    public JndiContextBuilder(@Reference JndiContextManager manager) {
        this.manager = manager;
    }

    public void build(PhysicalJndiContextDefinition definition) throws BuilderException {
        for (Map.Entry<String, Properties> entry : definition.getContexts().entrySet()) {
            try {
                this.manager.register(entry.getKey(), entry.getValue());
            }
            catch (NamingException e) {
                throw new BuilderException((Throwable)e);
            }
        }
    }

    public void remove(PhysicalJndiContextDefinition definition) throws BuilderException {
        for (String name : definition.getContexts().keySet()) {
            try {
                this.manager.unregister(name);
            }
            catch (NamingException e) {
                throw new BuilderException((Throwable)e);
            }
        }
    }
}

