/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.json.transform;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream2ObjectJsonTransformer
implements Transformer<InputStream, Object> {
    private ObjectMapper mapper;
    private Class<?> type;

    public Stream2ObjectJsonTransformer(Class<?> type, ObjectMapper mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public Object transform(InputStream source, ClassLoader loader) throws TransformationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            JsonParser jp = this.mapper.getJsonFactory().createJsonParser(source);
            jp.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            Object object = this.mapper.readValue(jp, this.type);
            return object;
        }
        catch (JsonMappingException e) {
            throw new TransformationException((Throwable)e);
        }
        catch (JsonParseException e) {
            throw new TransformationException((Throwable)e);
        }
        catch (IOException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

