/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.json.transform;

import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2ObjectJsonTransformer
implements Transformer<String, Object> {
    private ObjectMapper mapper;
    private Class<?> type;

    public String2ObjectJsonTransformer(Class<?> type, ObjectMapper mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public Object transform(String source, ClassLoader loader) throws TransformationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object object = this.mapper.readValue(source, this.type);
            return object;
        }
        catch (JsonMappingException e) {
            throw new TransformationException((Throwable)e);
        }
        catch (JsonParseException e) {
            throw new TransformationException((Throwable)e);
        }
        catch (IOException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

