/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.fabric3.implementation.pojo.builder.AbstractPropertyBuilder;
import org.fabric3.implementation.pojo.builder.ArrayBuilder;
import org.fabric3.implementation.pojo.builder.PropertyTransformException;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.ParamTypes;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBuilderImpl
extends AbstractPropertyBuilder
implements ArrayBuilder {
    public ArrayBuilderImpl(@Reference TransformerRegistry registry) {
        super(registry);
    }

    @Override
    public ObjectFactory<?> createFactory(String name, DataType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        try {
            Class componentType;
            Class type = componentType = dataType.getPhysical().getComponentType();
            if (type.isPrimitive()) {
                type = (Class)ParamTypes.PRIMITIVE_TO_OBJECT.get(type);
            }
            ArrayList types = new ArrayList();
            types.add(type);
            Transformer transformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, (DataType<?>)new JavaClass(type), types);
            Element root = value.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            Object array = Array.newInstance(componentType, nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i).getFirstChild();
                Object val = transformer.transform((Object)node, classLoader);
                Array.set(array, i, val);
            }
            return new SingletonObjectFactory(array);
        }
        catch (TransformationException e) {
            throw new PropertyTransformException("Unable to transform property value: " + name, e);
        }
    }
}

