/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fabric3.implementation.pojo.builder.AbstractPropertyBuilder;
import org.fabric3.implementation.pojo.builder.CollectionBuilder;
import org.fabric3.implementation.pojo.builder.PropertyTransformException;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionBuilderImpl
extends AbstractPropertyBuilder
implements CollectionBuilder {
    public CollectionBuilderImpl(@Reference TransformerRegistry registry) {
        super(registry);
    }

    @Override
    public <T> ObjectFactory<Collection<T>> createFactory(Collection<T> collection, String name, JavaGenericType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        try {
            List typeInfos = ((JavaTypeInfo)dataType.getLogical()).getParameterTypesInfos();
            if (typeInfos.size() < 1) {
                throw new PropertyTransformException("Collection properties must have a value type");
            }
            Class type = ((JavaTypeInfo)typeInfos.get(0)).getRawType();
            ArrayList types = new ArrayList();
            types.add(type);
            Transformer transformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, (DataType<?>)new JavaClass(type), types);
            Element root = value.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i).getFirstChild();
                Object val = transformer.transform((Object)node, classLoader);
                collection.add(val);
            }
            return new SingletonObjectFactory(collection);
        }
        catch (TransformationException e) {
            throw new PropertyTransformException("Unable to transform property value: " + name, e);
        }
    }
}

