/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodUtils {
    public static Method findMethod(PhysicalSourceDefinition sourceDefinition, PhysicalTargetDefinition targetDefinition, PhysicalOperationDefinition operation, Class<?> implementationClass, ClassLoader loader, ClassLoaderRegistry classLoaderRegistry) throws WireAttachException {
        List params = operation.getTargetParameterTypes();
        Class[] paramTypes = new Class[params.size()];
        assert (loader != null);
        for (int i = 0; i < params.size(); ++i) {
            String param = (String)params.get(i);
            try {
                paramTypes[i] = classLoaderRegistry.loadClass(loader, param);
                continue;
            }
            catch (ClassNotFoundException e) {
                URI sourceUri = sourceDefinition.getUri();
                URI targetUri = targetDefinition.getUri();
                throw new WireAttachException("Implementation class not found when wiring " + sourceUri + " to " + targetUri, (Throwable)e);
            }
        }
        Method method = null;
        if (operation.isRemotable()) {
            Method[] methods = implementationClass.getMethods();
            String name = operation.getName();
            for (Method entry : methods) {
                if (!name.equals(entry.getName())) continue;
                method = entry;
                break;
            }
            if (method == null) {
                URI sourceUri = sourceDefinition.getUri();
                URI targetUri = targetDefinition.getUri();
                throw new WireAttachException("No matching method found when wiring " + sourceUri + " to " + targetUri);
            }
        } else {
            try {
                method = implementationClass.getMethod(operation.getName(), paramTypes);
            }
            catch (NoSuchMethodException e) {
                URI sourceUri = sourceDefinition.getUri();
                URI targetUri = targetDefinition.getUri();
                throw new WireAttachException("No matching method found when wiring " + sourceUri + " to " + targetUri, (Throwable)e);
            }
        }
        return method;
    }
}

