/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.fabric3.implementation.pojo.builder.KeyInstantiationException;
import org.fabric3.implementation.pojo.provision.PojoSourceDefinition;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDSimpleType;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PojoSourceWireAttacher {
    private static final XSDSimpleType STRING_TYPE = new XSDSimpleType(String.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
    protected TransformerRegistry transformerRegistry;
    protected ClassLoaderRegistry classLoaderRegistry;

    protected PojoSourceWireAttacher(TransformerRegistry transformerRegistry, ClassLoaderRegistry loaderRegistry) {
        this.transformerRegistry = transformerRegistry;
        this.classLoaderRegistry = loaderRegistry;
    }

    protected Object getKey(PojoSourceDefinition sourceDefinition, PhysicalTargetDefinition targetDefinition) throws KeyInstantiationException {
        Class keyType;
        if (!sourceDefinition.isKeyed()) {
            throw new AssertionError((Object)"Attempt to read a key for a non-keyed reference");
        }
        String value = sourceDefinition.getKey();
        URI targetId = targetDefinition.getClassLoaderId();
        ClassLoader targetClassLoader = this.classLoaderRegistry.getClassLoader(targetId);
        try {
            keyType = this.classLoaderRegistry.loadClass(targetClassLoader, sourceDefinition.getKeyClassName());
        }
        catch (ClassNotFoundException e) {
            throw new KeyInstantiationException("Error loading reference key type for: " + sourceDefinition.getUri(), e);
        }
        if (String.class.equals((Object)keyType)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(keyType)) {
            Class enumClass = keyType;
            return Enum.valueOf(enumClass, value);
        }
        JavaClass targetType = new JavaClass(keyType);
        return this.createKey((DataType<?>)targetType, value, targetClassLoader);
    }

    private Object createKey(DataType<?> targetType, String value, ClassLoader classLoader) throws KeyInstantiationException {
        try {
            Class physical = targetType.getPhysical();
            ArrayList<Class> types = new ArrayList<Class>();
            types.add(physical);
            Transformer transformer = this.transformerRegistry.getTransformer((DataType)STRING_TYPE, targetType, types, types);
            if (transformer == null) {
                throw new KeyInstantiationException("No transformer for : " + targetType);
            }
            return transformer.transform((Object)value, classLoader);
        }
        catch (TransformationException e) {
            throw new KeyInstantiationException("Error transforming property", e);
        }
    }
}

