/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.implementation.pojo.builder.ArrayBuilder;
import org.fabric3.implementation.pojo.builder.CollectionBuilder;
import org.fabric3.implementation.pojo.builder.MapBuilder;
import org.fabric3.implementation.pojo.builder.ObjectBuilder;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyObjectFactoryBuilderImpl
implements PropertyObjectFactoryBuilder {
    private ArrayBuilder arrayBuilder;
    private CollectionBuilder collectionBuilder;
    private MapBuilder mapBuilder;
    private ObjectBuilder objectBuilder;

    public PropertyObjectFactoryBuilderImpl(@Reference ArrayBuilder arrayBuilder, @Reference CollectionBuilder collectionBuilder, @Reference MapBuilder mapBuilder, @Reference ObjectBuilder objectBuilder) {
        this.arrayBuilder = arrayBuilder;
        this.collectionBuilder = collectionBuilder;
        this.mapBuilder = mapBuilder;
        this.objectBuilder = objectBuilder;
    }

    @Override
    public ObjectFactory<?> createFactory(String name, DataType<?> dataType, Document value, boolean many, ClassLoader classLoader) throws BuilderException {
        Class physical = dataType.getPhysical();
        if (physical.isArray()) {
            return this.arrayBuilder.createFactory(name, dataType, value, classLoader);
        }
        if (Map.class.equals((Object)physical)) {
            return this.mapBuilder.createFactory(name, (JavaGenericType)dataType, value, classLoader);
        }
        if (List.class.equals((Object)physical)) {
            return this.collectionBuilder.createFactory(new ArrayList(), name, (JavaGenericType)dataType, value, classLoader);
        }
        if (Set.class.equals((Object)physical)) {
            return this.collectionBuilder.createFactory(new HashSet(), name, (JavaGenericType)dataType, value, classLoader);
        }
        if (LinkedList.class.equals((Object)physical)) {
            return this.collectionBuilder.createFactory(new LinkedList(), name, (JavaGenericType)dataType, value, classLoader);
        }
        return this.objectBuilder.createFactory(name, dataType, value, classLoader);
    }
}

