/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationRuntimeException;

public class InvokerInterceptor
implements Interceptor {
    private Method operation;
    private AtomicComponent component;
    private ClassLoader targetTCCLClassLoader;

    public InvokerInterceptor(Method operation, AtomicComponent component) {
        this.operation = operation;
        this.component = component;
    }

    public InvokerInterceptor(Method operation, AtomicComponent component, ClassLoader targetTCCLClassLoader) {
        this.operation = operation;
        this.component = component;
        this.targetTCCLClassLoader = targetTCCLClassLoader;
    }

    public void setNext(Interceptor next) {
        throw new IllegalStateException("This interceptor must be the last one in an target interceptor chain");
    }

    public Interceptor getNext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        Object instance;
        WorkContext workContext = msg.getWorkContext();
        try {
            instance = this.component.getInstance(workContext);
        }
        catch (InstanceLifecycleException e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
        try {
            Message message = this.invoke(msg, workContext, instance);
            return message;
        }
        finally {
            try {
                this.component.releaseInstance(instance, workContext);
            }
            catch (ComponentException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message invoke(Message msg, WorkContext workContext, Object instance) {
        block11: {
            WorkContext oldWorkContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
            try {
                Object body = msg.getBody();
                if (this.targetTCCLClassLoader == null) {
                    msg.setBody(this.operation.invoke(instance, (Object[])body));
                    break block11;
                }
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.targetTCCLClassLoader);
                    msg.setBody(this.operation.invoke(instance, (Object[])body));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (InvocationTargetException e) {
                msg.setBodyWithFault((Object)e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
            finally {
                WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
            }
        }
        return msg;
    }
}

