/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.implementation.pojo.reflection.EventInvoker;
import org.fabric3.implementation.pojo.reflection.ObjectCallbackException;

public class MethodEventInvoker
implements EventInvoker {
    private final Method method;

    public MethodEventInvoker(Method method) {
        assert (method != null);
        this.method = method;
        this.method.setAccessible(true);
    }

    public void invokeEvent(Object instance) throws ObjectCallbackException {
        try {
            this.method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            String signature = this.getSignature();
            throw new ObjectCallbackException("Invalid arguments provided when invoking method: " + signature, e.getCause());
        }
        catch (IllegalAccessException e) {
            String signature = this.getSignature();
            throw new ObjectCallbackException("Method is not accessible: " + signature);
        }
        catch (InvocationTargetException e) {
            String signature = this.getSignature();
            throw new ObjectCallbackException("Exception thrown when invoking method: " + signature, e.getCause());
        }
    }

    private String getSignature() {
        String name = this.method.getName();
        return this.method.getDeclaringClass().getName() + "." + name + "()";
    }
}

