/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.fabric3.implementation.pojo.instancefactory.ImplementationManager;
import org.fabric3.implementation.pojo.reflection.EventInvoker;
import org.fabric3.implementation.pojo.reflection.ObjectCallbackException;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceInitException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.objectfactory.Injector;
import org.fabric3.spi.objectfactory.ObjectCreationException;
import org.fabric3.spi.objectfactory.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveImplementationManager
implements ImplementationManager {
    private URI componentUri;
    private final ObjectFactory<?> constructor;
    private Injectable[] injectables;
    private final Injector<Object>[] injectors;
    private final EventInvoker initInvoker;
    private final EventInvoker destroyInvoker;
    private final ClassLoader cl;
    private final boolean reinjectable;
    private Set<Injector<Object>> updatedInjectors;

    public ReflectiveImplementationManager(URI componentUri, ObjectFactory<?> constructor, Injectable[] injectables, Injector<Object>[] injectors, EventInvoker initInvoker, EventInvoker destroyInvoker, boolean reinjectable, ClassLoader cl) {
        this.componentUri = componentUri;
        this.constructor = constructor;
        this.injectables = injectables;
        this.injectors = injectors;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.reinjectable = reinjectable;
        this.cl = cl;
        this.updatedInjectors = reinjectable ? new HashSet<Injector<Object>>() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object newInstance(WorkContext workContext) throws ObjectCreationException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        WorkContext oldContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
        try {
            Object instance = this.constructor.getInstance();
            if (this.injectors != null) {
                for (Injector<Object> injector : this.injectors) {
                    injector.inject(instance);
                }
            }
            Object object = instance;
            return object;
        }
        finally {
            WorkContextTunnel.setThreadWorkContext((WorkContext)oldContext);
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    @Override
    public void start(Object instance, WorkContext context) throws InstanceInitException {
        if (this.initInvoker != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            WorkContext oldWorkContext = WorkContextTunnel.getThreadWorkContext();
            try {
                Thread.currentThread().setContextClassLoader(this.cl);
                WorkContextTunnel.setThreadWorkContext((WorkContext)context);
                this.initInvoker.invokeEvent(instance);
            }
            catch (ObjectCallbackException e) {
                throw new InstanceInitException("Error initializing instance for: " + this.componentUri, (Throwable)((Object)e));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
                WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Object instance, WorkContext context) throws InstanceDestructionException {
        block5: {
            WorkContext oldWorkContext = WorkContextTunnel.getThreadWorkContext();
            try {
                if (this.destroyInvoker == null) break block5;
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.cl);
                    WorkContextTunnel.setThreadWorkContext((WorkContext)context);
                    this.destroyInvoker.invokeEvent(instance);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                    WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
                }
            }
            catch (ObjectCallbackException e) {
                throw new InstanceDestructionException("Error destroying instance for: " + this.componentUri, (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void reinject(Object instance) throws InstanceLifecycleException {
        if (!this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable:" + this.componentUri);
        }
        try {
            for (Injector<Object> injector : this.updatedInjectors) {
                injector.inject(instance);
            }
            this.updatedInjectors.clear();
        }
        catch (ObjectCreationException ex) {
            throw new InstanceLifecycleException("Unable to reinject references on component: " + this.componentUri, (Throwable)ex);
        }
    }

    @Override
    public void updated(Object instance, String referenceName) {
        if (instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable: " + this.componentUri);
        }
        for (int i = 0; i < this.injectables.length; ++i) {
            Injectable attribute = this.injectables[i];
            if (!attribute.getName().equals(referenceName)) continue;
            Injector<Object> injector = this.injectors[i];
            if (instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }

    @Override
    public void removed(Object instance, String referenceName) {
        if (instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable: " + this.componentUri);
        }
        for (int i = 0; i < this.injectables.length; ++i) {
            Injectable attribute = this.injectables[i];
            if (!attribute.getName().equals(referenceName)) continue;
            Injector<Object> injector = this.injectors[i];
            injector.clearObjectFactory();
            if (instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }
}

