/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.fabric3.implementation.pojo.instancefactory.ImplementationBuildException;
import org.fabric3.implementation.pojo.instancefactory.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.pojo.reflection.ReflectiveImplementationManagerFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.Signature;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ReflectiveImplementationManagerFactoryBuilder
implements ImplementationManagerFactoryBuilder {
    private ClassLoaderRegistry classLoaderRegistry;

    public ReflectiveImplementationManagerFactoryBuilder(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public ReflectiveImplementationManagerFactory build(ImplementationManagerDefinition definition, ClassLoader cl) throws ImplementationBuildException {
        try {
            URI componentUri = definition.getComponentUri();
            String className = definition.getImplementationClass();
            Class implClass = this.classLoaderRegistry.loadClass(cl, className);
            Constructor ctr = this.getConstructor(implClass, definition.getConstructor());
            Map<InjectionSite, Injectable> injectionSites = definition.getConstruction();
            Injectable[] cdiSources = new Injectable[ctr.getParameterTypes().length];
            for (Map.Entry<InjectionSite, Injectable> entry : injectionSites.entrySet()) {
                InjectionSite site = entry.getKey();
                Injectable injectable = entry.getValue();
                ConstructorInjectionSite constructorSite = (ConstructorInjectionSite)site;
                cdiSources[constructorSite.getParam()] = injectable;
            }
            for (int i = 0; i < cdiSources.length; ++i) {
                if (cdiSources[i] != null) continue;
                String clazz = ctr.getName();
                throw new ImplementationBuildException("No injection value for constructor parameter " + i + " in class " + clazz, clazz);
            }
            Method initMethod = this.getMethod(implClass, definition.getInitMethod());
            Method destroyMethod = this.getMethod(implClass, definition.getDestroyMethod());
            Map<InjectionSite, Injectable> postConstruction = definition.getPostConstruction();
            List<Injectable> construction = Arrays.asList(cdiSources);
            boolean reinjectable = definition.isReinjectable();
            return new ReflectiveImplementationManagerFactory(componentUri, ctr, construction, postConstruction, initMethod, destroyMethod, reinjectable, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new ImplementationBuildException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ImplementationBuildException(ex);
        }
    }

    private Method getMethod(Class<?> implClass, Signature signature) throws NoSuchMethodException, ClassNotFoundException {
        return signature == null ? null : signature.getMethod(implClass);
    }

    private <T> Constructor<T> getConstructor(Class<T> implClass, Signature signature) throws ClassNotFoundException, NoSuchMethodException {
        Constructor ctr = signature.getConstructor(implClass);
        ctr.setAccessible(true);
        return ctr;
    }
}

