/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.ws.model.WsBindingDefinition;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.fabric3.spi.model.type.binding.BindingHandlerDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WsBindingLoader
extends AbstractValidatingTypeLoader<WsBindingDefinition> {
    private static final String WSDL_NS = "http://www.w3.org/2004/08/wsdl-instance";
    private final LoaderHelper loaderHelper;
    private final LoaderRegistry registry;

    public WsBindingLoader(@Reference LoaderHelper loaderHelper, @Reference LoaderRegistry registry) {
        this.loaderHelper = loaderHelper;
        this.registry = registry;
        this.addAttributes(new String[]{"uri", "impl", "wsdlElement", "wsdlLocation", "requires", "policySets", "name", "retries"});
    }

    public WsBindingDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String wsdlElement = reader.getAttributeValue(null, "wsdlElement");
        String wsdlLocation = reader.getAttributeValue(WSDL_NS, "wsdlLocation");
        int retries = this.parseRetries(reader, context);
        String bindingName = reader.getAttributeValue(null, "name");
        URI targetUri = this.parseTargetUri(reader, context);
        WsBindingDefinition binding = new WsBindingDefinition(bindingName, targetUri, wsdlLocation, wsdlElement, retries);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)binding, reader, context);
        block7: while (true) {
            switch (reader.next()) {
                case 1: {
                    try {
                        Object elementValue = this.registry.load(reader, Object.class, context);
                        if (elementValue instanceof BindingHandlerDefinition) {
                            binding.addHandler((BindingHandlerDefinition)elementValue);
                            break;
                        }
                        if (!(elementValue instanceof Map)) continue block7;
                        binding.setConfiguration((Map)elementValue);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                    }
                    continue block7;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"binding.ws".equals(name)) break;
                    return binding;
                }
                case 8: {
                    return binding;
                }
            }
        }
    }

    private URI parseTargetUri(XMLStreamReader reader, IntrospectionContext context) {
        String uri = reader.getAttributeValue(null, "uri");
        URI targetUri = null;
        if (uri != null) {
            try {
                targetUri = new URI(uri);
            }
            catch (URISyntaxException ex) {
                InvalidValue failure = new InvalidValue("The web services binding URI is not a valid: " + uri, reader);
                context.addError((ValidationFailure)failure);
            }
        }
        return targetUri;
    }

    private int parseRetries(XMLStreamReader reader, IntrospectionContext context) {
        String retries = reader.getAttributeValue(null, "retries");
        if (retries != null) {
            try {
                return Integer.parseInt(retries);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("The retries attribute must be a valid number", reader);
                context.addError((ValidationFailure)error);
            }
        }
        return 0;
    }
}

