/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.spi.model.type.binding.BindingHandlerDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsBindingDefinition
extends BindingDefinition {
    private static final long serialVersionUID = -2097314069798596206L;
    public static final QName BINDING_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.ws");
    private final String wsdlLocation;
    private final String wsdlElement;
    private Map<String, String> configuration;
    private int retries;
    private List<BindingHandlerDefinition> handlers;

    public WsBindingDefinition(String name, URI targetUri, String wsdlLocation, String wsdlElement, int retries) {
        super(name, targetUri, BINDING_QNAME);
        this.wsdlElement = wsdlElement;
        this.wsdlLocation = wsdlLocation;
        this.retries = retries;
        this.handlers = new ArrayList<BindingHandlerDefinition>();
        this.configuration = Collections.emptyMap();
    }

    public String getWsdlElement() {
        return this.wsdlElement;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public int getRetries() {
        return this.retries;
    }

    public List<BindingHandlerDefinition> getHandlers() {
        return this.handlers;
    }

    public void addHandler(BindingHandlerDefinition handler) {
        this.handlers.add(handler);
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }
}

