/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.datasource.introspection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.datasource.model.DataSourceResource;
import org.fabric3.datasource.spi.DataSourceConfiguration;
import org.fabric3.datasource.spi.DataSourceType;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DataSourceResourceLoader
implements TypeLoader<DataSourceResource> {
    public DataSourceResource load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ArrayList<DataSourceConfiguration> configurations = new ArrayList<DataSourceConfiguration>();
        DataSourceConfiguration configuration = null;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name;
                    if ("datasource".equals(reader.getName().getLocalPart())) {
                        DataSourceType dataSourceType;
                        name = this.readMandatoryAttribute("name", reader, context);
                        String type = reader.getAttributeValue(null, "type");
                        if (type == null) {
                            dataSourceType = DataSourceType.NON_XA;
                        } else {
                            try {
                                dataSourceType = DataSourceType.valueOf(type.toUpperCase());
                            }
                            catch (IllegalArgumentException e) {
                                InvalidValue error = new InvalidValue("Datasource type must be either xa or non_xa", reader, (Throwable)e);
                                context.addError((ValidationFailure)error);
                                dataSourceType = DataSourceType.NON_XA;
                            }
                        }
                        String driver = this.readMandatoryAttribute("driver", reader, context);
                        configuration = new DataSourceConfiguration(name, driver, dataSourceType);
                        List<String> aliases = this.readAliases(reader);
                        configuration.setAliases(aliases);
                        String url = reader.getAttributeValue(null, "url");
                        configuration.setUrl(url);
                        String username = reader.getAttributeValue(null, "username");
                        configuration.setUsername(username);
                        String password = reader.getAttributeValue(null, "password");
                        configuration.setPassword(password);
                        break;
                    }
                    if (configuration == null) break;
                    name = reader.getName().getLocalPart();
                    String value = reader.getElementText();
                    if ("maxPoolSize".equals(name)) {
                        configuration.setMaxPoolSize(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("minPoolSize".equals(name)) {
                        configuration.setMinPoolSize(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("connectionTimeout".equals(name)) {
                        configuration.setConnectionTimeout(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("loginTimeout".equals(name)) {
                        configuration.setLoginTimeout(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("maintenanceInterval".equals(name)) {
                        configuration.setMaintenanceInterval(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("maxIdle".equals(name)) {
                        configuration.setMaxIdle(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("poolSize".equals(name)) {
                        configuration.setPoolSize(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("reap".equals(name)) {
                        configuration.setReap(this.parseInt(value, reader, context));
                        break;
                    }
                    if ("query".equals(name)) {
                        configuration.setQuery(value);
                        break;
                    }
                    configuration.setProperty(name, value);
                    break;
                }
                case 2: {
                    if ("datasource".equals(reader.getName().getLocalPart())) {
                        configurations.add(configuration);
                        break;
                    }
                    if (!"datasources".equals(reader.getName().getLocalPart())) break;
                    return new DataSourceResource(configurations);
                }
            }
        }
    }

    private List<String> readAliases(XMLStreamReader reader) {
        String aliasesAttr = reader.getAttributeValue(null, "aliases");
        if (aliasesAttr == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(aliasesAttr.split(","));
    }

    private String readMandatoryAttribute(String name, XMLStreamReader reader, IntrospectionContext context) {
        String val = reader.getAttributeValue(null, name);
        if (val == null) {
            InvalidValue error = new InvalidValue("Datasource " + name + " must be specified", reader);
            context.addError((ValidationFailure)error);
        }
        return val;
    }

    private int parseInt(String value, XMLStreamReader reader, IntrospectionContext context) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            context.addError((ValidationFailure)new InvalidValue("Invalid value", reader, (Throwable)e));
            return 0;
        }
    }
}

