/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.datasource.runtime;

import org.fabric3.datasource.provision.PhysicalDataSourceResource;
import org.fabric3.datasource.runtime.DataSourceBuilderException;
import org.fabric3.datasource.spi.DataSourceConfiguration;
import org.fabric3.datasource.spi.DataSourceFactory;
import org.fabric3.datasource.spi.DataSourceFactoryException;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.resource.ResourceBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DataSourceBuilder
implements ResourceBuilder<PhysicalDataSourceResource> {
    private DataSourceFactory factory;

    public DataSourceBuilder(@Reference DataSourceFactory factory) {
        this.factory = factory;
    }

    public void build(PhysicalDataSourceResource definition) throws BuilderException {
        for (DataSourceConfiguration configuration : definition.getConfigurations()) {
            try {
                this.factory.create(configuration);
            }
            catch (DataSourceFactoryException e) {
                throw new DataSourceBuilderException((Throwable)((Object)e));
            }
        }
    }

    public void remove(PhysicalDataSourceResource definition) throws BuilderException {
        for (DataSourceConfiguration configuration : definition.getConfigurations()) {
            try {
                this.factory.remove(configuration);
            }
            catch (DataSourceFactoryException e) {
                throw new DataSourceBuilderException((Throwable)((Object)e));
            }
        }
    }
}

