/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.datasource.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.fabric3.datasource.spi.DataSourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceConfiguration
implements Serializable {
    private static final long serialVersionUID = -2790525523535863636L;
    private String name;
    private List<String> aliases;
    private String driverClass;
    private DataSourceType type;
    private String url;
    private String username;
    private String password;
    private int maxPoolSize = -1;
    private int minPoolSize = -1;
    private int connectionTimeout = -1;
    private int loginTimeout = -1;
    private int maintenanceInterval = -1;
    private int maxIdle = -1;
    private int poolSize = -1;
    private int reap = -1;
    private String query;
    private Properties properties = new Properties();

    public DataSourceConfiguration(String name, String driverClass, DataSourceType type) {
        this.name = name;
        this.driverClass = driverClass;
        this.type = type;
        this.aliases = Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    public void setMaintenanceInterval(int maintenanceInterval) {
        this.maintenanceInterval = maintenanceInterval;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getReap() {
        return this.reap;
    }

    public void setReap(int reap) {
        this.reap = reap;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

