/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.recovery.contribution;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.recovery.contribution.InvalidRepositoryIndexException;
import org.fabric3.recovery.contribution.ProfileTrackerMonitor;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.RuntimeRecover;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(names={ContributionServiceListener.class, Fabric3EventListener.class})
@EagerInit
public class ProfileTracker
implements ContributionServiceListener,
Fabric3EventListener<RuntimeRecover> {
    private static final QName CONTRIBUTION = new QName("urn:fabric3.org", "contribution");
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private File repositoryIndex;
    private ProfileTrackerMonitor monitor;
    private EventService eventService;
    private MetaDataStore store;
    private Map<URI, List<URI>> mappings;

    public ProfileTracker(@Reference XMLFactory factory, @Reference EventService eventService, @Reference HostInfo hostInfo, @Reference MetaDataStore store, @Monitor ProfileTrackerMonitor monitor) {
        this.eventService = eventService;
        this.store = store;
        this.inputFactory = factory.newInputFactoryInstance();
        this.outputFactory = factory.newOutputFactoryInstance();
        this.monitor = monitor;
        this.repositoryIndex = new File(hostInfo.getDataDir(), "profiles.xml");
        this.mappings = new HashMap<URI, List<URI>>();
    }

    @Init
    public void init() {
        this.eventService.subscribe(RuntimeRecover.class, (Fabric3EventListener)this);
    }

    public void onEvent(RuntimeRecover event) {
        if (!this.repositoryIndex.exists()) {
            return;
        }
        try {
            this.mappings = this.parse();
            ArrayList<URI> deleted = new ArrayList<URI>();
            for (Map.Entry<URI, List<URI>> entry : this.mappings.entrySet()) {
                URI uri = entry.getKey();
                Contribution contribution = this.store.find(uri);
                if (contribution == null) {
                    deleted.add(uri);
                    continue;
                }
                contribution.addProfiles(entry.getValue());
            }
            for (URI uri : deleted) {
                this.mappings.remove(uri);
            }
            this.persist();
        }
        catch (FileNotFoundException e) {
            this.monitor.error(e);
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        catch (InvalidRepositoryIndexException e) {
            this.monitor.error((Exception)((Object)e));
        }
    }

    public void onStore(Contribution contribution) {
        List profiles = contribution.getProfiles();
        if (profiles.isEmpty()) {
            return;
        }
        URI uri = contribution.getUri();
        this.mappings.put(uri, profiles);
        this.persist();
    }

    public void onProcessManifest(Contribution contribution) {
    }

    public void onInstall(Contribution contribution) {
        this.update(contribution);
    }

    public void onUpdate(Contribution contribution) {
        this.update(contribution);
    }

    public void onUninstall(Contribution contribution) {
        this.update(contribution);
    }

    public void onRemove(Contribution contribution) {
        if (!contribution.isPersistent()) {
            return;
        }
        this.mappings.remove(contribution.getUri());
        this.persist();
    }

    private void update(Contribution contribution) {
        if (!contribution.isPersistent()) {
            return;
        }
        this.mappings.put(contribution.getUri(), contribution.getProfiles());
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        if (this.mappings.isEmpty()) {
            return;
        }
        FilterOutputStream stream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.repositoryIndex);
            stream = new BufferedOutputStream(fos);
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(stream);
            writer.writeStartDocument();
            writer.writeStartElement("profiles");
            writer.writeDefaultNamespace("urn:fabric3.org");
            for (Map.Entry<URI, List<URI>> entry : this.mappings.entrySet()) {
                writer.writeStartElement("contribution");
                writer.writeAttribute("uri", entry.getKey().toString());
                List<URI> profiles = entry.getValue();
                if (!profiles.isEmpty()) {
                    StringBuilder b = new StringBuilder();
                    for (int i = 0; i < profiles.size() - 1; ++i) {
                        URI profile = entry.getValue().get(i);
                        b.append(profile.toString()).append(" ");
                    }
                    b.append(profiles.get(profiles.size() - 1));
                    writer.writeAttribute("profiles", b.toString());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (FileNotFoundException e) {
            this.monitor.error(e);
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private Map<URI, List<URI>> parse() throws FileNotFoundException, XMLStreamException, InvalidRepositoryIndexException {
        HashMap<URI, List<URI>> profileMappings = new HashMap<URI, List<URI>>();
        FileInputStream fis = new FileInputStream(this.repositoryIndex);
        BufferedInputStream stream = new BufferedInputStream(fis);
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(stream);
        try {
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        if (!CONTRIBUTION.equals(reader.getName())) break;
                        String uriStr = reader.getAttributeValue(null, "uri");
                        if (uriStr == null) {
                            throw this.createException("URI attribute missing ", reader, null);
                        }
                        URI uri = URI.create(uriStr);
                        ArrayList<URI> profiles = new ArrayList<URI>();
                        String profilesStr = reader.getAttributeValue(null, "profiles");
                        if (profilesStr != null) {
                            String[] tokens;
                            for (String token : tokens = profilesStr.split(" ")) {
                                try {
                                    profiles.add(new URI(token));
                                }
                                catch (URISyntaxException e) {
                                    throw this.createException("Invalid profile name:" + token, reader, e);
                                }
                            }
                        }
                        profileMappings.put(uri, profiles);
                        break;
                    }
                    case 8: {
                        HashMap<URI, List<URI>> hashMap = profileMappings;
                        return hashMap;
                    }
                }
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    private InvalidRepositoryIndexException createException(String message, XMLStreamReader reader, Exception e) {
        Location location = reader.getLocation();
        String msg = message + "[" + location.getLineNumber() + "," + location.getColumnNumber() + "]";
        if (e == null) {
            return new InvalidRepositoryIndexException(msg);
        }
        return new InvalidRepositoryIndexException(msg, e);
    }
}

