/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.recovery.domain;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.recovery.domain.DeployTrackerMonitor;
import org.fabric3.spi.domain.DeployListener;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FSDeployTracker
implements DeployListener {
    private static final String NO_PLAN = "";
    private File domainLog;
    private XMLOutputFactory outputFactory;
    private DeployTrackerMonitor monitor;
    private List<URI> contributions;
    private Map<QName, String> deployables;

    public FSDeployTracker(@Reference XMLFactory factory, @Reference HostInfo info, @Monitor DeployTrackerMonitor monitor) {
        this.monitor = monitor;
        this.outputFactory = factory.newOutputFactoryInstance();
        this.contributions = new ArrayList<URI>();
        this.deployables = new HashMap<QName, String>();
        this.domainLog = new File(info.getDataDir(), "domain.xml");
    }

    public void onDeploy(URI uri) {
        this.contributions.add(uri);
        this.persist();
    }

    public void onUnDeploy(URI uri) {
        this.contributions.remove(uri);
        this.persist();
    }

    public void onDeploy(QName included, String plan) {
        if (plan == null) {
            plan = NO_PLAN;
        }
        this.deployables.put(included, plan);
        this.persist();
    }

    public void onUndeploy(QName undeployed) {
        this.deployables.remove(undeployed);
        this.persist();
    }

    public void onDeployCompleted(URI uri) {
    }

    public void onUnDeployCompleted(URI contribution) {
    }

    public void onDeployCompleted(QName deployable, String plan) {
    }

    public void onUndeployCompleted(QName undeployed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        FilterOutputStream stream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.domainLog);
            stream = new BufferedOutputStream(fos);
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(stream);
            writer.writeStartDocument();
            writer.writeStartElement("domain");
            writer.writeDefaultNamespace("urn:fabric3.org");
            this.writeContributions(writer);
            this.writeDeployables(writer);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (FileNotFoundException e) {
            this.monitor.error(e);
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void writeContributions(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("contributions");
        for (URI uri : this.contributions) {
            writer.writeStartElement("contribution");
            writer.writeAttribute("uri", uri.toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeDeployables(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("deployables");
        for (Map.Entry<QName, String> entry : this.deployables.entrySet()) {
            QName deployable = entry.getKey();
            String plan = entry.getValue();
            writer.writeStartElement("deployable");
            writer.writeAttribute("namespace", deployable.getNamespaceURI());
            writer.writeAttribute("name", deployable.getLocalPart());
            if (plan != NO_PLAN) {
                writer.writeAttribute("plan", plan);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

