/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.util.closure;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fabric3.util.closure.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <OBJECT> List<OBJECT> filter(List<OBJECT> source, Closure<OBJECT, Boolean> filter) {
        ArrayList<OBJECT> result = new ArrayList<OBJECT>();
        for (OBJECT object : source) {
            if (!filter.execute(object).booleanValue()) continue;
            result.add(object);
        }
        return result;
    }

    public static <OBJECT> Set<OBJECT> filter(Set<OBJECT> source, Closure<OBJECT, Boolean> filter) {
        LinkedHashSet<OBJECT> result = new LinkedHashSet<OBJECT>();
        for (OBJECT object : source) {
            if (!filter.execute(object).booleanValue()) continue;
            result.add(object);
        }
        return result;
    }

    public static <SOURCE, RESULT> Set<RESULT> transform(Set<SOURCE> source, Closure<SOURCE, RESULT> transformer) {
        LinkedHashSet<RESULT> result = new LinkedHashSet<RESULT>();
        for (SOURCE object : source) {
            result.add(transformer.execute(object));
        }
        return result;
    }
}

