/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.util.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fabric3.util.graph.Cycle;
import org.fabric3.util.graph.CycleDetector;
import org.fabric3.util.graph.DepthFirstTraverser;
import org.fabric3.util.graph.DepthFirstTraverserImpl;
import org.fabric3.util.graph.DirectedGraph;
import org.fabric3.util.graph.DirectedGraphImpl;
import org.fabric3.util.graph.Edge;
import org.fabric3.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleDetectorImpl<T>
implements CycleDetector<T> {
    private DepthFirstTraverser<T> traverser = new DepthFirstTraverserImpl();

    @Override
    public boolean hasCycles(DirectedGraph<T> graph) {
        for (Vertex<T> vertex : graph.getVertices()) {
            if (!this.isCycle(graph, vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DirectedGraph<T> findCycleSubgraph(DirectedGraph<T> graph) {
        DirectedGraphImpl<T> subGraph = new DirectedGraphImpl<T>();
        for (Edge<T> edge : graph.getEdges()) {
            if (!this.isPath(graph, edge.getSink(), edge.getSource())) continue;
            subGraph.add(edge);
        }
        return subGraph;
    }

    @Override
    public List<Cycle<T>> findCycles(DirectedGraph<T> graph) {
        ArrayList<Cycle<T>> cycles = new ArrayList<Cycle<T>>();
        for (Edge<T> edge : graph.getEdges()) {
            List<Vertex<T>> path = this.getPath(graph, edge.getSink(), edge.getSource());
            if (path.isEmpty()) continue;
            Cycle<T> cycle = this.searchCycle(cycles, edge);
            if (cycle == null) {
                cycle = new Cycle();
                cycle.setOriginPath(path);
                cycles.add(cycle);
                continue;
            }
            cycle.setBackPath(path);
        }
        return cycles;
    }

    private Cycle<T> searchCycle(List<Cycle<T>> cycles, Edge<T> edge) {
        for (Cycle<T> cycle : cycles) {
            List<Vertex<T>> path = cycle.getOriginPath();
            Vertex<T> vertex = path.get(0);
            if (!vertex.equals(edge.getSink())) continue;
            return cycle;
        }
        return null;
    }

    private boolean isCycle(DirectedGraph<T> graph, Vertex<T> from) {
        Set<Edge<T>> edges = graph.getOutgoingEdges(from);
        for (Edge<T> edge : edges) {
            Vertex<T> opposite = edge.getOppositeVertex(from);
            if (!this.isPath(graph, opposite, from)) continue;
            return true;
        }
        return false;
    }

    private boolean isPath(DirectedGraph<T> graph, Vertex<T> start, Vertex<T> end) {
        return !this.getPath(graph, start, end).isEmpty();
    }

    private List<Vertex<T>> getPath(DirectedGraph<T> graph, Vertex<T> start, Vertex<T> end) {
        List<Vertex<T>> path = this.traverser.traversePath(graph, start, end);
        Collections.reverse(path);
        return path;
    }
}

