/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.util.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fabric3.util.graph.DepthFirstTraverser;
import org.fabric3.util.graph.DirectedGraph;
import org.fabric3.util.graph.TerminatingVisitor;
import org.fabric3.util.graph.TrueVisitor;
import org.fabric3.util.graph.Vertex;
import org.fabric3.util.graph.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstTraverserImpl<T>
implements DepthFirstTraverser<T> {
    @Override
    public List<Vertex<T>> traverse(DirectedGraph<T> graph, Vertex<T> start) {
        return this.traverse(graph, start, new TrueVisitor());
    }

    @Override
    public List<Vertex<T>> traversePath(DirectedGraph<T> graph, Vertex<T> start, Vertex<T> end) {
        TerminatingVisitor<T> visitor = new TerminatingVisitor<T>(end);
        List<Vertex<T>> path = this.traverse(graph, start, visitor);
        if (visitor.wasFound()) {
            return path;
        }
        return Collections.emptyList();
    }

    private List<Vertex<T>> traverse(DirectedGraph<T> graph, Vertex<T> start, Visitor<T> visitor) {
        ArrayList<Vertex<T>> visited = new ArrayList<Vertex<T>>();
        ArrayList<Vertex<T>> stack = new ArrayList<Vertex<T>>();
        HashSet<Vertex<T>> seen = new HashSet<Vertex<T>>(visited);
        stack.add(start);
        seen.add(start);
        do {
            Vertex next = (Vertex)stack.remove(stack.size() - 1);
            visited.add(next);
            if (!visitor.visit(next)) {
                return visited;
            }
            Set<Vertex<T>> adjacentVertices = graph.getAdjacentVertices(next);
            for (Vertex<T> v : adjacentVertices) {
                seen.add(v);
                stack.add(v);
            }
        } while (!stack.isEmpty());
        return visited;
    }
}

