/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.util.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.fabric3.util.graph.CycleException;
import org.fabric3.util.graph.DepthFirstTraverserImpl;
import org.fabric3.util.graph.DirectedGraph;
import org.fabric3.util.graph.TopologicalSorter;
import org.fabric3.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSorterImpl<T>
implements TopologicalSorter<T> {
    @Override
    public List<Vertex<T>> sort(DirectedGraph<T> dag) throws CycleException {
        HashMap<Vertex<T>, AtomicInteger> vertexMap = new HashMap<Vertex<T>, AtomicInteger>();
        ArrayList<Vertex<T>> roots = new ArrayList<Vertex<T>>();
        Set<Vertex<T>> vertices = dag.getVertices();
        for (Vertex<T> v : vertices) {
            int incoming = dag.getIncomingEdges(v).size();
            if (incoming == 0) {
                roots.add(v);
                continue;
            }
            AtomicInteger count = new AtomicInteger();
            count.set(incoming);
            vertexMap.put(v, count);
        }
        return this.sort(dag, vertexMap, roots);
    }

    @Override
    public List<Vertex<T>> sort(DirectedGraph<T> dag, Vertex<T> start) throws CycleException {
        DepthFirstTraverserImpl<T> dfs = new DepthFirstTraverserImpl<T>();
        HashMap<Vertex<T>, AtomicInteger> vertexMap = new HashMap<Vertex<T>, AtomicInteger>();
        List<Vertex<T>> vertices = dfs.traverse(dag, start);
        for (Vertex<T> v : vertices) {
            List<Vertex<T>> outgoing = dag.getOutgoingAdjacentVertices(v);
            for (Vertex<T> child : outgoing) {
                AtomicInteger count = (AtomicInteger)vertexMap.get(child);
                if (count == null) {
                    count = new AtomicInteger();
                    vertexMap.put(child, count);
                }
                count.incrementAndGet();
            }
        }
        ArrayList<Vertex<T>> roots = new ArrayList<Vertex<T>>();
        roots.add(start);
        return this.sort(dag, vertexMap, roots);
    }

    @Override
    public List<Vertex<T>> reverseSort(DirectedGraph<T> dag) throws CycleException {
        List<Vertex<T>> sortSequence = this.sort(dag);
        Collections.reverse(sortSequence);
        return sortSequence;
    }

    @Override
    public List<Vertex<T>> reverseSort(DirectedGraph<T> dag, Vertex<T> start) throws CycleException {
        List<Vertex<T>> sorted = this.sort(dag, start);
        Collections.reverse(sorted);
        return sorted;
    }

    private List<Vertex<T>> sort(DirectedGraph<T> dag, Map<Vertex<T>, AtomicInteger> vertices, List<Vertex<T>> roots) throws CycleException {
        ArrayList<Vertex<T>> visited = new ArrayList<Vertex<T>>();
        int num = vertices.size() + roots.size();
        while (!roots.isEmpty()) {
            Vertex<T> v = roots.remove(roots.size() - 1);
            visited.add(v);
            List<Vertex<T>> outgoing = dag.getOutgoingAdjacentVertices(v);
            for (Vertex<T> child : outgoing) {
                AtomicInteger count = vertices.get(child);
                if (count.decrementAndGet() != 0) continue;
                roots.add(child);
            }
        }
        if (visited.size() != num) {
            throw new CycleException();
        }
        return visited;
    }
}

