/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicyPhase;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.policy.NullPolicyResult;
import org.fabric3.policy.PolicyResultImpl;
import org.fabric3.policy.resolver.ImplementationPolicyResolver;
import org.fabric3.policy.resolver.InteractionPolicyResolver;
import org.fabric3.spi.contract.OperationNotFoundException;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.generator.PolicyMetadata;
import org.fabric3.spi.generator.policy.PolicyResolutionException;
import org.fabric3.spi.generator.policy.PolicyResolver;
import org.fabric3.spi.generator.policy.PolicyResult;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.binding.LocalBindingDefinition;
import org.fabric3.spi.model.type.binding.RemoteBindingDefinition;
import org.fabric3.util.closure.Closure;
import org.fabric3.util.closure.CollectionUtils;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyResolver
implements PolicyResolver {
    private static final QName IMPLEMENTATION_SYSTEM = new QName("urn:fabric3.org", "implementation.system");
    private static final QName IMPLEMENTATION_SINGLETON = new QName("urn:fabric3.org", "singleton");
    private static final PolicyResult EMPTY_RESULT = new NullPolicyResult();
    private static final Operation DEFINITION = new Operation("_fabric3Generated", null, null, null);
    private static final Closure<PolicySet, Boolean> INTERCEPTION = new Closure<PolicySet, Boolean>(){

        public Boolean execute(PolicySet policySet) {
            return policySet.getPhase() == PolicyPhase.INTERCEPTION;
        }
    };
    private static final Closure<PolicySet, Boolean> PROVIDED = new Closure<PolicySet, Boolean>(){

        public Boolean execute(PolicySet policySet) {
            return policySet.getPhase() == PolicyPhase.PROVIDED;
        }
    };
    private InteractionPolicyResolver interactionResolver;
    private ImplementationPolicyResolver implementationResolver;
    private OperationResolver operationResolver;

    public DefaultPolicyResolver(@Reference InteractionPolicyResolver interactionResolver, @Reference ImplementationPolicyResolver implementationResolver, @Reference OperationResolver operationResolver) {
        this.interactionResolver = interactionResolver;
        this.implementationResolver = implementationResolver;
        this.operationResolver = operationResolver;
    }

    public PolicyResult resolvePolicies(LogicalBinding<?> binding) throws PolicyResolutionException {
        Bindable parent = (Bindable)binding.getParent();
        LogicalBinding remoteBinding = new LogicalBinding((BindingDefinition)RemoteBindingDefinition.INSTANCE, parent);
        Bindable bindable = (Bindable)binding.getParent();
        if (bindable instanceof LogicalReference) {
            return this.resolvePolicies(bindable.getOperations(), remoteBinding, binding, (LogicalComponent)bindable.getParent(), null);
        }
        if (bindable instanceof LogicalService) {
            return this.resolvePolicies(bindable.getOperations(), binding, remoteBinding, null, (LogicalComponent)bindable.getParent());
        }
        throw new UnsupportedOperationException();
    }

    public PolicyResult resolveCallbackPolicies(LogicalBinding<?> binding) throws PolicyResolutionException {
        LogicalBinding remoteBinding = new LogicalBinding((BindingDefinition)RemoteBindingDefinition.INSTANCE, (Bindable)binding.getParent());
        Bindable bindable = (Bindable)binding.getParent();
        if (bindable instanceof LogicalReference) {
            return this.resolvePolicies(bindable.getCallbackOperations(), remoteBinding, binding, (LogicalComponent)bindable.getParent(), null);
        }
        if (bindable instanceof LogicalService) {
            return this.resolvePolicies(bindable.getCallbackOperations(), remoteBinding, binding, (LogicalComponent)bindable.getParent(), null);
        }
        throw new IllegalArgumentException("Only services and references can have callback operations");
    }

    public PolicyResult resolveLocalPolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget().getLeafService();
        LogicalComponent source = (LogicalComponent)reference.getParent();
        LogicalComponent target = service.getLeafComponent();
        LogicalBinding sourceBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)reference);
        LogicalBinding targetBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)service);
        return this.resolvePolicies(reference.getOperations(), sourceBinding, targetBinding, source, target);
    }

    public PolicyResult resolveLocalCallbackPolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent targetComponent = (LogicalComponent)reference.getParent();
        ServiceContract referenceCallbackContract = reference.getServiceContract().getCallbackContract();
        LogicalService callbackService = targetComponent.getService(referenceCallbackContract.getInterfaceName());
        LogicalBinding sourceBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)callbackService);
        LogicalBinding targetBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)reference);
        LogicalComponent sourceComponent = service.getLeafComponent();
        return this.resolvePolicies(service.getCallbackOperations(), sourceBinding, targetBinding, sourceComponent, targetComponent);
    }

    public PolicyResult resolveRemotePolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent source = (LogicalComponent)reference.getParent();
        LogicalComponent target = service.getLeafComponent();
        LogicalBinding serviceBinding = wire.getTargetBinding();
        List sourceOperations = reference.getOperations();
        return this.resolvePolicies(sourceOperations, serviceBinding, serviceBinding, source, target);
    }

    public PolicyResult resolveRemoteCallbackPolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalComponent target = (LogicalComponent)reference.getParent();
        ServiceContract referenceContract = reference.getServiceContract();
        ServiceContract referenceCallbackContract = referenceContract.getCallbackContract();
        LogicalBinding referenceBinding = (LogicalBinding)reference.getCallbackBindings().get(0);
        LogicalService callbackService = target.getService(referenceCallbackContract.getInterfaceName());
        List operations = reference.getCallbackOperations();
        LogicalBinding sourceBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)callbackService);
        return this.resolvePolicies(operations, sourceBinding, referenceBinding, null, target);
    }

    public PolicyResult resolvePolicies(LogicalConsumer consumer) throws PolicyResolutionException {
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        if (this.noPolicy(component)) {
            return EMPTY_RESULT;
        }
        LogicalOperation operation = new LogicalOperation(DEFINITION, (LogicalAttachPoint)consumer);
        Set<Intent> targetOperationIntents = this.interactionResolver.resolveProvidedIntents(operation, LocalBindingDefinition.INSTANCE.getType());
        PolicyResultImpl policyResult = new PolicyResultImpl();
        policyResult.addTargetIntents(operation, targetOperationIntents);
        Set<Intent> sourceImplementationIntents = this.implementationResolver.resolveProvidedIntents(component, operation);
        policyResult.addSourceIntents(operation, sourceImplementationIntents);
        Set<PolicySet> policies = this.interactionResolver.resolvePolicySets(operation, (LogicalScaArtifact<?>)consumer, LocalBindingDefinition.INSTANCE.getType());
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        policies = this.implementationResolver.resolvePolicySets(component, operation);
        PolicyMetadata metadata = policyResult.getMetadata(operation);
        metadata.addAll(operation.getDefinition().getMetadata());
        metadata.addAll(((LogicalComponent)((LogicalAttachPoint)operation.getParent()).getParent()).getDefinition().getImplementation().getMetadata());
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        return policyResult;
    }

    private PolicyResult resolvePolicies(List<LogicalOperation> operations, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding, LogicalComponent<?> source, LogicalComponent<?> target) throws PolicyResolutionException {
        if (this.noPolicy(source) && this.noPolicy(target)) {
            return EMPTY_RESULT;
        }
        PolicyResultImpl policyResult = new PolicyResultImpl();
        this.resolveEndpointPolicies(policyResult, sourceBinding, targetBinding);
        for (LogicalOperation operation : operations) {
            this.resolveOperationPolicies(operation, policyResult, sourceBinding, targetBinding, target);
        }
        return policyResult;
    }

    private void resolveEndpointPolicies(PolicyResultImpl policyResult, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding) throws PolicyResolutionException {
        Set<Intent> sourceEndpointIntents = this.interactionResolver.resolveProvidedIntents(sourceBinding);
        policyResult.addSourceEndpointIntents(sourceEndpointIntents);
        Set<Intent> targetEndpointIntents = this.interactionResolver.resolveProvidedIntents(targetBinding);
        policyResult.addTargetEndpointIntents(targetEndpointIntents);
        Set<PolicySet> endpointPolicies = this.interactionResolver.resolvePolicySets(sourceBinding);
        policyResult.addSourceEndpointPolicySets(CollectionUtils.filter(endpointPolicies, PROVIDED));
        policyResult.addInterceptedEndpointPolicySets(CollectionUtils.filter(endpointPolicies, INTERCEPTION));
        endpointPolicies = this.interactionResolver.resolvePolicySets(targetBinding);
        policyResult.addTargetEndpointPolicySets(CollectionUtils.filter(endpointPolicies, PROVIDED));
        policyResult.addInterceptedEndpointPolicySets(CollectionUtils.filter(endpointPolicies, INTERCEPTION));
    }

    private void resolveOperationPolicies(LogicalOperation operation, PolicyResultImpl policyResult, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding, LogicalComponent<?> target) throws PolicyResolutionException {
        QName sourceType = sourceBinding.getDefinition().getType();
        Set<Intent> sourceOperationIntents = this.interactionResolver.resolveProvidedIntents(operation, sourceType);
        policyResult.addSourceIntents(operation, sourceOperationIntents);
        QName targetType = targetBinding.getDefinition().getType();
        Set<Intent> targetOperationIntents = this.interactionResolver.resolveProvidedIntents(operation, targetType);
        policyResult.addTargetIntents(operation, targetOperationIntents);
        if (target != null) {
            Set<Intent> sourceImplementationIntents = this.implementationResolver.resolveProvidedIntents(target, operation);
            policyResult.addSourceIntents(operation, sourceImplementationIntents);
        }
        Set<PolicySet> policies = this.interactionResolver.resolvePolicySets(operation, (LogicalScaArtifact<?>)sourceBinding, sourceType);
        policyResult.addSourcePolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        policies = this.interactionResolver.resolvePolicySets(operation, (LogicalScaArtifact<?>)targetBinding, targetType);
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        if (target != null) {
            Bindable parent = (Bindable)targetBinding.getParent();
            LogicalOperation targetOperation = this.matchOperation(operation, parent);
            policies = this.implementationResolver.resolvePolicySets(target, targetOperation);
            PolicyMetadata metadata = policyResult.getMetadata(operation);
            metadata.addAll(targetOperation.getDefinition().getMetadata());
            metadata.addAll(((LogicalComponent)((LogicalAttachPoint)targetOperation.getParent()).getParent()).getDefinition().getImplementation().getMetadata());
            policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
            policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        }
    }

    private LogicalOperation matchOperation(LogicalOperation operation, Bindable bindable) throws PolicyResolutionException {
        String name = operation.getDefinition().getName();
        List operations = bindable instanceof LogicalReference ? bindable.getCallbackOperations() : bindable.getOperations();
        try {
            LogicalOperation matched = this.operationResolver.resolve(operation, operations);
            if (matched == null) {
                throw new AssertionError((Object)("No matching operation for " + name));
            }
            return matched;
        }
        catch (OperationNotFoundException e) {
            throw new PolicyResolutionException((Throwable)e);
        }
    }

    private boolean noPolicy(LogicalComponent<?> component) {
        return component != null && (component.getDefinition().getImplementation().isType(IMPLEMENTATION_SYSTEM) || component.getDefinition().getImplementation().isType(IMPLEMENTATION_SINGLETON));
    }
}

