/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.model.instance.LogicalOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectivePolicyImpl
implements EffectivePolicy {
    private Set<Intent> endpointIntents = new HashSet<Intent>();
    private Set<PolicySet> endpointPolicySets = new HashSet<PolicySet>();
    private Map<LogicalOperation, List<Intent>> intentMap = new HashMap<LogicalOperation, List<Intent>>();
    private Map<LogicalOperation, List<PolicySet>> policySetMap = new HashMap<LogicalOperation, List<PolicySet>>();

    public Set<Intent> getEndpointIntents() {
        return this.endpointIntents;
    }

    public Set<PolicySet> getEndpointPolicySets() {
        return this.endpointPolicySets;
    }

    public List<Intent> getOperationIntents() {
        ArrayList<Intent> ret = new ArrayList<Intent>();
        for (LogicalOperation operation : this.intentMap.keySet()) {
            ret.addAll(this.getIntents(operation));
        }
        return ret;
    }

    public Map<LogicalOperation, List<PolicySet>> getOperationPolicySets() {
        return this.policySetMap;
    }

    public List<Intent> getIntents(LogicalOperation operation) {
        return this.intentMap.get(operation);
    }

    public List<PolicySet> getPolicySets(LogicalOperation operation) {
        return this.policySetMap.get(operation);
    }

    void addEndpointIntents(Set<Intent> intents) {
        this.endpointIntents.addAll(intents);
    }

    void addEndpointPolicySets(Set<PolicySet> policySets) {
        this.endpointPolicySets.addAll(policySets);
    }

    void addIntents(LogicalOperation operation, Set<Intent> intents) {
        if (!this.intentMap.containsKey(operation)) {
            this.intentMap.put(operation, new ArrayList());
        }
        this.intentMap.get(operation).addAll(intents);
    }

    void addPolicySets(LogicalOperation operation, Set<PolicySet> policySets) {
        if (!this.policySetMap.containsKey(operation)) {
            this.policySetMap.put(operation, new ArrayList());
        }
        this.policySetMap.get(operation).addAll(policySets);
    }
}

