/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.policy.EffectivePolicyImpl;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.generator.PolicyMetadata;
import org.fabric3.spi.generator.policy.PolicyResult;
import org.fabric3.spi.model.instance.LogicalOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyResultImpl
implements PolicyResult {
    private EffectivePolicyImpl sourcePolicy = new EffectivePolicyImpl();
    private EffectivePolicyImpl targetPolicy = new EffectivePolicyImpl();
    private Set<PolicySet> interceptedEndpointPolicySets = new HashSet<PolicySet>();
    private Map<LogicalOperation, PolicyMetadata> metadataMap = new HashMap<LogicalOperation, PolicyMetadata>();
    private Map<LogicalOperation, List<PolicySet>> interceptedPolicySets = new HashMap<LogicalOperation, List<PolicySet>>();

    public EffectivePolicy getSourcePolicy() {
        return this.sourcePolicy;
    }

    public EffectivePolicy getTargetPolicy() {
        return this.targetPolicy;
    }

    public Set<PolicySet> getInterceptedEndpointPolicySets() {
        return this.interceptedEndpointPolicySets;
    }

    public Map<LogicalOperation, List<PolicySet>> getInterceptedPolicySets() {
        return this.interceptedPolicySets;
    }

    public List<PolicySet> getInterceptedPolicySets(LogicalOperation operation) {
        List<PolicySet> sets = this.interceptedPolicySets.get(operation);
        if (sets == null) {
            return Collections.emptyList();
        }
        return sets;
    }

    public PolicyMetadata getMetadata(LogicalOperation operation) {
        PolicyMetadata metadata = this.metadataMap.get(operation);
        if (metadata == null) {
            metadata = new PolicyMetadata();
            this.metadataMap.put(operation, metadata);
        }
        return metadata;
    }

    public Map<LogicalOperation, PolicyMetadata> getMetadata() {
        return this.metadataMap;
    }

    void addSourceEndpointIntents(Set<Intent> intents) {
        this.sourcePolicy.addEndpointIntents(intents);
    }

    void addSourceIntents(LogicalOperation operation, Set<Intent> intents) {
        this.sourcePolicy.addIntents(operation, intents);
    }

    void addTargetEndpointIntents(Set<Intent> intents) {
        this.targetPolicy.addEndpointIntents(intents);
    }

    void addTargetIntents(LogicalOperation operation, Set<Intent> intents) {
        this.targetPolicy.addIntents(operation, intents);
    }

    void addSourceEndpointPolicySets(Set<PolicySet> policySets) {
        this.sourcePolicy.addEndpointPolicySets(policySets);
    }

    void addSourcePolicySets(LogicalOperation operation, Set<PolicySet> policySets) {
        this.sourcePolicy.addPolicySets(operation, policySets);
    }

    void addTargetEndpointPolicySets(Set<PolicySet> policySets) {
        this.targetPolicy.addEndpointPolicySets(policySets);
    }

    void addTargetPolicySets(LogicalOperation operation, Set<PolicySet> policySets) {
        this.targetPolicy.addPolicySets(operation, policySets);
    }

    public void addInterceptedEndpointPolicySets(Set<PolicySet> policySets) {
        this.interceptedEndpointPolicySets.addAll(policySets);
    }

    void addInterceptedPolicySets(LogicalOperation operation, Set<PolicySet> policySets) {
        if (!this.interceptedPolicySets.containsKey(operation)) {
            this.interceptedPolicySets.put(operation, new ArrayList());
        }
        List<PolicySet> interceptedSets = this.interceptedPolicySets.get(operation);
        for (PolicySet policySet : policySets) {
            if (interceptedSets.contains(policySet)) continue;
            interceptedSets.add(policySet);
        }
    }
}

