/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.interceptor.simple;

import java.net.URI;
import org.fabric3.policy.interceptor.simple.SimpleInterceptorBuilderException;
import org.fabric3.policy.interceptor.simple.SimpleInterceptorDefinition;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.interceptor.InterceptorBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.wire.Interceptor;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInterceptorBuilder
implements InterceptorBuilder<SimpleInterceptorDefinition> {
    private ClassLoaderRegistry registry;

    public SimpleInterceptorBuilder(@Reference ClassLoaderRegistry registry) {
        this.registry = registry;
    }

    public Interceptor build(SimpleInterceptorDefinition definition) throws BuilderException {
        String className = definition.getInterceptorClass();
        URI classLoaderUri = definition.getPolicyClassLoaderId();
        ClassLoader loader = this.registry.getClassLoader(classLoaderUri);
        if (loader == null) {
            throw new SimpleInterceptorBuilderException("Interceptor classloader not found: " + classLoaderUri);
        }
        try {
            Class<?> interceptorClass = loader.loadClass(className);
            return (Interceptor)interceptorClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new SimpleInterceptorBuilderException("Unable to instantiate", className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new SimpleInterceptorBuilderException("Cannot access class or constructor", className, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new SimpleInterceptorBuilderException("Class not found", className, ex);
        }
    }
}

