/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.xpath;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationRefFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() != 1) {
            throw new FunctionCallException("Invalid number of arguments for OperationRef(): " + args.size());
        }
        Object arg = args.get(0);
        String[] tokens = arg.toString().split("/");
        if (tokens.length != 2) {
            throw new FunctionCallException("Invalid Service/Operation name: " + arg);
        }
        String interfaceName = tokens[0];
        String operationName = tokens[1];
        List nodeSet = context.getNodeSet();
        ArrayList<LogicalOperation> operations = new ArrayList<LogicalOperation>();
        for (LogicalComponent component : nodeSet) {
            this.find(interfaceName, operationName, component, operations);
        }
        return operations;
    }

    private void find(String interfaceName, String operationName, LogicalComponent<?> component, List<LogicalOperation> operations) {
        ServiceContract contract;
        ServiceDefinition definition;
        for (LogicalService service : component.getServices()) {
            definition = service.getDefinition();
            contract = definition.getServiceContract();
            if (!contract.getInterfaceName().equals(interfaceName)) continue;
            for (LogicalOperation operation : service.getOperations()) {
                if (!operation.getDefinition().getName().equals(operationName)) continue;
                operations.add(operation);
            }
        }
        for (LogicalReference reference : component.getReferences()) {
            definition = reference.getDefinition();
            contract = definition.getServiceContract();
            if (!contract.getInterfaceName().equals(interfaceName)) continue;
            for (LogicalOperation operation : reference.getOperations()) {
                if (!operation.getDefinition().getName().equals(operationName)) continue;
                operations.add(operation);
            }
        }
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
            for (LogicalComponent child : composite.getComponents()) {
                this.find(interfaceName, operationName, child, operations);
            }
        }
    }
}

