/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk;

import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.implementation.pojo.builder.ProxyCreationException;
import org.fabric3.implementation.pojo.builder.WireProxyService;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.objectfactory.ObjectCreationException;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.InvocationChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackWireObjectFactory<T>
implements ObjectFactory<T> {
    private Class<T> interfaze;
    private boolean multiThreaded;
    private WireProxyService proxyService;
    private Map<String, Map<Method, InvocationChain>> mappings;

    public CallbackWireObjectFactory(Class<T> interfaze, boolean multiThreaded, WireProxyService proxyService, Map<String, Map<Method, InvocationChain>> mappings) {
        this.interfaze = interfaze;
        this.multiThreaded = multiThreaded;
        this.proxyService = proxyService;
        this.mappings = mappings;
    }

    public T getInstance() throws ObjectCreationException {
        if (this.multiThreaded) {
            try {
                return this.interfaze.cast(this.proxyService.createMultiThreadedCallbackProxy(this.interfaze, this.mappings));
            }
            catch (ProxyCreationException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        CallFrame frame = WorkContextTunnel.getThreadWorkContext().peekCallFrame();
        String callbackUri = frame.getCallbackUri();
        Map<Method, InvocationChain> mapping = this.mappings.get(callbackUri);
        assert (mapping != null);
        return this.interfaze.cast(this.proxyService.createCallbackProxy(this.interfaze, mapping));
    }

    public void updateMappings(String callbackUri, Map<Method, InvocationChain> chains) {
        this.mappings.put(callbackUri, chains);
    }
}

