/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.binding.jms.generator.JmsGenerationException;
import org.fabric3.binding.jms.generator.JmsGeneratorHelper;
import org.fabric3.binding.jms.generator.PayloadTypeIntrospector;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.ActivationSpec;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsSourceDefinition;
import org.fabric3.binding.jms.spi.provision.JmsTargetDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.PayloadType;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.spi.generator.BindingGenerator;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.type.xsd.XSDType;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JmsBindingGenerator
implements BindingGenerator<JmsBindingDefinition> {
    private static final QName TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay");
    private static final QName IMMEDIATE_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "immediateOneWay");
    private static final QName ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private static final QName NON_PERSISTENT = new QName("urn:fabric3.org", "nonPersistent");
    private static final DataType<?> ANY = new XSDType(String.class, new QName("http://www.w3.org/2001/XMLSchema", "anyType"));
    private PayloadTypeIntrospector introspector;
    private HostInfo info;
    private JmsResourceProvisioner provisioner;

    public JmsBindingGenerator(@Reference PayloadTypeIntrospector introspector, @Reference HostInfo info) {
        this.introspector = introspector;
        this.info = info;
    }

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public JmsSourceDefinition generateSource(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        TransactionType transactionType = this.getTransactionType(operations, policy);
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        String specifier = JmsGeneratorHelper.getSourceSpecifier(((Bindable)binding.getParent()).getUri());
        metadata.setClientIdSpecifier(specifier);
        this.processServiceResponse(metadata, contract);
        this.generateIntents(binding, metadata);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        List<PhysicalBindingHandlerDefinition> handlers = JmsGeneratorHelper.generateBindingHandlers(this.info.getDomain(), (JmsBindingDefinition)binding.getDefinition());
        JmsSourceDefinition definition = null;
        for (OperationPayloadTypes types : payloadTypes) {
            if (PayloadType.XML != types.getInputType()) continue;
            definition = new JmsSourceDefinition(uri, metadata, payloadTypes, transactionType, handlers, ANY);
            break;
        }
        if (definition == null) {
            definition = new JmsSourceDefinition(uri, metadata, payloadTypes, transactionType, handlers);
        }
        if (this.provisioner != null) {
            this.provisioner.generateSource(definition);
        }
        this.setDefaultFactoryConfigurations(metadata, transactionType, specifier);
        this.processDestinationDefinitions(metadata, false);
        return definition;
    }

    public JmsTargetDefinition generateTarget(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        TransactionType transactionType = this.getTransactionType(operations, policy);
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        this.processReferenceResponse(metadata, contract);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        List<PhysicalBindingHandlerDefinition> handlers = JmsGeneratorHelper.generateBindingHandlers(this.info.getDomain(), (JmsBindingDefinition)binding.getDefinition());
        JmsTargetDefinition definition = null;
        for (OperationPayloadTypes types : payloadTypes) {
            if (PayloadType.XML != types.getInputType()) continue;
            definition = new JmsTargetDefinition(uri, metadata, payloadTypes, transactionType, handlers, ANY);
            break;
        }
        if (definition == null) {
            definition = new JmsTargetDefinition(uri, metadata, payloadTypes, transactionType, handlers);
        }
        if (this.provisioner != null) {
            this.provisioner.generateTarget(definition);
        }
        String specifier = JmsGeneratorHelper.getTargetSpecifier(((Bindable)binding.getParent()).getUri());
        this.setDefaultFactoryConfigurations(metadata, transactionType, specifier);
        this.processDestinationDefinitions(metadata, true);
        if (contract.getCallbackContract() != null) {
            for (LogicalBinding callbackBinding : ((Bindable)binding.getParent()).getCallbackBindings()) {
                if (!(callbackBinding.getDefinition() instanceof JmsBindingDefinition)) continue;
                JmsBindingDefinition callbackDefinition = (JmsBindingDefinition)callbackBinding.getDefinition();
                DestinationDefinition callbackDestination = callbackDefinition.getJmsMetadata().getDestination();
                definition.setCallbackDestination(callbackDestination);
            }
        }
        return definition;
    }

    public JmsTargetDefinition generateServiceBindingTarget(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        return this.generateTarget((LogicalBinding)binding, contract, (List)operations, policy);
    }

    private void processReferenceResponse(JmsBindingMetadata metadata, ServiceContract contract) {
        if (metadata.isResponse()) {
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.getIntents().contains(ONEWAY)) continue;
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(metadata.getConnectionFactory());
            DestinationDefinition destinationDefinition = new DestinationDefinition();
            destinationDefinition.setCreate(CreateOption.IF_NOT_EXIST);
            destinationDefinition.setName(metadata.getDestination().getName() + "Response");
            responseDefinition.setDestination(destinationDefinition);
            metadata.setResponse(responseDefinition);
            break;
        }
    }

    private void processServiceResponse(JmsBindingMetadata metadata, ServiceContract contract) throws JmsGenerationException {
        if (metadata.isResponse()) {
            if (metadata.getResponse().getActivationSpec() != null) {
                throw new JmsGenerationException("Activation spec not allowed on a service binding response");
            }
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.getIntents().contains(ONEWAY)) continue;
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(metadata.getConnectionFactory());
            metadata.setResponse(responseDefinition);
            break;
        }
    }

    private void generateIntents(LogicalBinding<JmsBindingDefinition> binding, JmsBindingMetadata metadata) {
        Set intents = ((JmsBindingDefinition)binding.getDefinition()).getIntents();
        if (intents.contains(NON_PERSISTENT)) {
            metadata.getHeaders().setDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
    }

    private TransactionType getTransactionType(List<LogicalOperation> operations, EffectivePolicy policy) {
        for (LogicalOperation operation : operations) {
            for (Intent intent : policy.getIntents(operation)) {
                QName name = intent.getName();
                if (TRANSACTED_ONEWAY.equals(name)) {
                    return TransactionType.GLOBAL;
                }
                if (!IMMEDIATE_ONEWAY.equals(name)) continue;
                return TransactionType.NONE;
            }
        }
        for (Intent intent : policy.getEndpointIntents()) {
            QName name = intent.getName();
            if (TRANSACTED_ONEWAY.equals(name)) {
                return TransactionType.GLOBAL;
            }
            if (!IMMEDIATE_ONEWAY.equals(name)) continue;
            return TransactionType.NONE;
        }
        return TransactionType.NONE;
    }

    private List<OperationPayloadTypes> processPayloadTypes(ServiceContract serviceContract) throws JmsGenerationException {
        ArrayList<OperationPayloadTypes> types = new ArrayList<OperationPayloadTypes>();
        for (Operation operation : serviceContract.getOperations()) {
            OperationPayloadTypes payloadType = this.introspector.introspect(operation);
            types.add(payloadType);
        }
        return types;
    }

    private void setDefaultFactoryConfigurations(JmsBindingMetadata metadata, TransactionType trxType, String specifier) {
        ConnectionFactoryDefinition factory = metadata.getConnectionFactory();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(factory, specifier, trxType);
        ConnectionFactoryDefinition responseFactory = metadata.getResponseConnectionFactory();
        if (responseFactory != null) {
            JmsGeneratorHelper.generateDefaultFactoryConfiguration(responseFactory, specifier + "Response", trxType);
        }
    }

    private void processDestinationDefinitions(JmsBindingMetadata metadata, boolean reference) throws JmsGenerationException {
        ActivationSpec spec;
        DestinationDefinition destination = metadata.getDestination();
        if (destination == null && (spec = metadata.getActivationSpec()) != null) {
            if (reference) {
                throw new JmsGenerationException("Activation specification not allowed on a reference");
            }
            destination = this.populateActivationInformation(spec);
            metadata.setDestination(destination);
        }
        DestinationDefinition responseDestination = metadata.getResponseDestination();
        ResponseDefinition responseDefinition = metadata.getResponse();
        if (responseDestination == null && responseDefinition != null && responseDefinition.getActivationSpec() != null) {
            ActivationSpec spec2 = responseDefinition.getActivationSpec();
            responseDestination = this.populateActivationInformation(spec2);
            responseDefinition.setDestination(responseDestination);
        }
    }

    private DestinationDefinition populateActivationInformation(ActivationSpec spec) {
        DestinationDefinition destination = new DestinationDefinition();
        destination.setCreate(spec.getCreate());
        destination.setName(spec.getName());
        destination.addProperties(spec.getProperties());
        return destination;
    }
}

